pro draw_axes, x_range, y_range
  plot, [0], [0], /nodata, /noerase, color = 0, xrange = x_range, yrange = y_range, $
        xstyle = 1, ystyle = 1, ymargin = [2.75, 1.5], xmargin = [4, 1.5]
end

pro seamfix_graph_setup
  @seamfix_common

  wset, 2
  device, copy = [0, 0, 848, 200, 0, 0, 1]

  avgX = (graph_x2 + graph_x1) / 2
  avgY = (graph_y2 + graph_y1) / 2

  if graph_x2 - graph_x1 lt 0.05 then begin
      graph_x2 = avgX + 0.25
      graph_x1 = avgX - 0.25
  endif
  if graph_y2 - graph_y1 lt 0.05 then begin
      graph_y2 = avgY + 0.25
      graph_y1 = avgY - 0.25
  endif
  
  draw_axes, [graph_x1, graph_x2], [graph_y1, graph_y2]

  xw = !x.window
  yw = !y.window
  graph_pix_x1 = xw[0] * 848 + 1
  graph_pix_x2 = xw[1] * 848 + 1
  graph_pix_xrange = graph_pix_x2 - graph_pix_x1
  graph_pix_xscale = graph_pix_xrange / (graph_x2 - graph_x1)
  graph_pix_y1 = yw[0] * 200 + 1
  graph_pix_y2 = yw[1] * 200 + 1
  graph_pix_yrange = graph_pix_y2 - graph_pix_y1
  graph_pix_yscale = graph_pix_yrange / (graph_y2 - graph_y1)

  device, copy = [graph_pix_x1, 200 + graph_pix_y1, graph_pix_xrange, graph_pix_yrange, $
                  graph_pix_x1, graph_pix_y1, 1]

  if 100 gt graph_x1 then begin
    hl_x1 = ((graph_x1 > 90) - graph_x1) * graph_pix_xscale + graph_pix_x1
    hl_x2 = (100 - graph_x1) * graph_pix_xscale + graph_pix_x1 + 1
    device, copy = [hl_x1, graph_pix_y1, hl_x2 - hl_x1, graph_pix_yrange, hl_x1, graph_pix_y1, 1]
  endif
    
  if 180 lt graph_x2 then begin
    hl_x1 = ((180 - graph_x1) * graph_pix_xscale + graph_pix_x1) > 0 < 847
    hl_x2 = (((graph_x2 < 190) - graph_x1) * graph_pix_xscale + graph_pix_x1 + 1) < 847 > 1
    device, copy = [hl_x1, graph_pix_y1, hl_x2 - hl_x1, graph_pix_yrange, hl_x1, graph_pix_y1, 1]
  endif
    

  draw_axes, [graph_x1, graph_x2], [graph_y1, graph_y2]
end
