pro seamfix
  @euv_imtool-commons
  @seamfix_common

  draw_main_dragging = 0
  draw_graph_zooming = 0
  draw_graph_dragging = 0
  avgVal = fltarr(140)
  fileOpened = 0
  graphExists = 0
  graphmode = 0
  multFacts = fltarr(140) + 1

  restore, 'multfacts.sav'

  device, retain = 2

  ; create window and widgets
  w_base = widget_base(xsize = 856, ysize = 512, title = 'seamfix')

  w_button1 = widget_button(w_base, uvalue = 'button_newdirectory', $
                            xoffset = 288, yoffset = 284, $
                            xsize = 138, ysize = 20, $
                            value = 'Open folder')

  w_button_prev = widget_button(w_base, uvalue = 'button_prev', $
                                xoffset = 288, yoffset = 4, $
                                xsize = 45, ysize = 20, $
                                value = 'Prev', sensitive = 0)

  w_button_zoomout = widget_button(w_base, uvalue = 'button_zoomout', $
                                   xoffset = 430, yoffset = 284, $
                                   xsize = 138, ysize = 20, $
                                   value = 'Zoom out graph', sensitive = 0)

  w_button_graphfactors = widget_button(w_base, uvalue = 'button_graphfactors', $
                                     xoffset = 430, yoffset = 260, $
                                     xsize = 138, ysize = 20, $
                                     value = 'Graph factors', sensitive = 0)

  w_button_savefactors = widget_button(w_base, uvalue = 'button_savefactors', $
                                     xoffset = 288, yoffset = 260, $
                                     xsize = 138, ysize = 20, $
                                     value = 'Save factors', sensitive = 0)

  w_button_resetgraph = widget_button(w_base, uvalue = 'button_resetgraph', $
                                     xoffset = 288, yoffset = 236, $
                                     xsize = 138, ysize = 20, $
                                     value = 'Reset graph', sensitive = 0)
  
  w_button_savefits = widget_button(w_base, uvalue = 'button_savefits', $
                                    xoffset = 430, yoffset = 236, $
                                    xsize = 138, ysize = 20, $
                                    value = 'Save modified FITS', sensitive = 0)

  w_button_next = widget_button(w_base, uvalue = 'button_next', $
                                xoffset = 523, yoffset = 4, $
                                xsize = 45, ysize = 20, $
                                value = 'Next', sensitive = 0)


  w_slider_time = widget_slider(w_base, uvalue = 'slider_time', $
                                xoffset = 288, yoffset = 28, $
                                xsize = 280, ysize = 20, sensitive = 0)

  w_label_fname = widget_label(w_base, $
                              xoffset = 288, yoffset = 48, $
                              xsize = 280, ysize = 20, $
                              /align_center, sensitive = 0, $
                              value = '')
  
  w_label_date = widget_label(w_base, $
                              xoffset = 348, yoffset = 4, $
                              xsize = 160, ysize = 20, $
                              /align_center, sensitive = 0, $
                              value = 'yyyy/ddd/mm:hh')
  
  w_draw_main = widget_draw(w_base, uvalue = 'draw_main', $
                            xoffset = 4, yoffset = 4, $
                            xsize = 280, ysize = 300, $
                            /motion_events, /button_events)
  
  w_draw_graph = widget_draw(w_base, uvalue = 'draw_graph', $
                             xoffset = 4, yoffset = 308, $
                             xsize = 848, ysize = 200, $
                             /motion_events, /button_events)
  
  w_draw_secondary = widget_draw(w_base, uvalue = 'draw_secondary', $
                                 xoffset = 572, yoffset = 4, $
                                 xsize = 280, ysize = 300, $
                                 /motion_events, /button_events)            
  
  ; display window
  widget_control, w_base, /realize

  widget_control, w_draw_main, get_value = h_draw_main
  widget_control, w_draw_secondary, get_value = h_draw_secondary
  widget_control, w_draw_graph, get_value = h_draw_graph

  window, 1, /pixmap, xsize = 848, ysize = 1600
  window, 2, /pixmap, xsize = 848, ysize = 200

  wset, 1
  for i = 0, 197, 2 do begin
      c = '010101'XUL * (212 + fix((i) / 198.0D * 43)) 
      c2 = c - '0f0f0f'XUL
      polyfill, [1, 1, 847, 847], [i, i+2, i+2, i], color = c, /device
      polyfill, [1, 1, 847, 847], [200 + i, 200 + (i+2), 200 + (i+2), 200 + i], $
                color = c2, /device
  endfor

  wset, h_draw_graph
  device, copy = [0, 0, 848, 200, 0, 0, 1]

  device, cursor_standard = 33

  ; start event handler
  xmanager, 'seamfix', w_base, /no_block
end
