; activate background buffers
device, retain = 2

; initialize GUI widgets
w_base  = widget_base(xsize = 706, ysize = 630, title = 'RotSum')
w_draw1 = widget_draw(w_base, uvalue = 'd_main', xsize = 280, ysize = 300, $
                      xoffset = 2, yoffset = 2, /motion_events, $
                      /button_events)
w_draw2 = widget_draw(w_base, uvalue = 'd_big', xsize = 420, ysize = 450, $
                      xoffset = 284, yoffset = 2, /button_events)
w_draw3 = widget_draw(w_base, uvalue = 'd_pick', xsize = 702, ysize = 152, $
                      xoffset = 2, yoffset = 454, /button_events)
w_slider = widget_slider(w_base, uvalue = 's_pick', xsize = 702, ysize = 20, $
                         xoffset = 2, yoffset = 608, minimum = 0, $
                         maximum = 1, sensitive = 0, /drag)
w_label1 = widget_label(w_base, ysize = 20, $
                        xoffset = 4, yoffset = 404, /align_left, $
                        value = 'Rotation speed (degrees/hour):')
w_text = widget_text(w_base, scr_xsize = 70, scr_ysize = 30, /editable, $
                     xoffset = 212, yoffset = 398, value = '15.000', $
                     uvalue = 't_rot')
w_datelabel = widget_label(w_base, xsize = 200, ysize = 24, $
                           xoffset = 42, yoffset = 304, /align_center, $
                           value = 'yyyy/ddd/hh:mm')
w_go = widget_button(w_base, xsize = 280, ysize = 24, $
                     xoffset = 2, yoffset = 428, value = 'Calculate', $
                     uvalue = 'b_go')
w_prev = widget_button(w_base, xsize = 30, ysize = 24, $
                       xoffset = 2, yoffset = 304, value = '<<', $
                       uvalue = 'b_prev', sensitive = 0)
w_next = widget_button(w_base, xsize = 30, ysize = 24, $
                       xoffset = 252, yoffset = 304, value = '>>', $
                       uvalue = 'b_next', sensitive = 0)
w_save2 = widget_button(w_base, xsize = 139, ysize = 24, $
                       xoffset = 2, yoffset = 372, uvalue = 'b_save', $
                       value = 'Export composite', sensitive = 0)
                     
w_save = widget_button(w_base, xsize = 139, ysize = 24, $
                       xoffset = 143, yoffset = 372, uvalue = 'b_save2', $
                       value = 'Export rotated frames', sensitive = 0)
w_pal = widget_button(w_base, xsize = 139, ysize = 24, $
                      xoffset = 2, yoffset = 346, uvalue = 'b_pal', $
                      value = 'Modify palette', sensitive = 1)
                     
; display the window
widget_control, w_base, /realize

; get window handles for draw widgets
widget_control, w_draw1, get_value = h_draw1
widget_control, w_draw2, get_value = h_draw2
widget_control, w_draw3, get_value = h_draw3

; setup preview widgets
if filesN gt 5 then begin
    widget_control, w_slider, set_slider_max = (filesN - 5), sensitive = 1
endif
