pro rotsum_scandirectory, dir
  @rotsum_common

  w2_base = widget_base(xsize = 600, ysize = 36, $
                        title = 'Scanning directory ...')
  w2_draw = widget_draw(w2_base, xsize = 596, ysize = 32, xoffset = 2, $
                        yoffset = 2)

  widget_control, w2_base, /realize

  widget_control, w2_draw, get_value = h2_draw

  polyfill, [-1, -1, 2, 2], [-1, 2, 2, -1], color = '775544'XUL, /normal

  if dir ne '' then $
    if strmid(dir, strlen(dir) - 1, 1) ne directoryDelimiter then $
      dir = dir + directoryDelimiter

  filesN = 0
  files = findfile(dir + '*.fits', count = filesN)

  dateStrings = strarr(filesN)

  window, 1, /pixmap, xsize = filesN * 140 > 700, ysize = 300
  window, 2, /pixmap, xsize = 700, ysize = 150

  for i = 0.0D, filesN - 1 do begin
      res = readfits(files[i], fitshead)
      dateStrings[i] = strmid(sxpar(fitshead,'IMTIME'), 0, 14)
      print, dateStrings[i]
      if max(res) lt 4 then begin
          res = rebin(res, 140, 150, /sample)
      endif else begin
          res = alog10(res) > 0
      endelse

      res = res / 3.2 * 255

      wset, 1
      tv, res, i * 140, 0
      xyouts, i * 140 + 70, 4, dateStrings[i], color = 'ffffff'XUL, /device, $
              alignment = 0.5, charsize = 0.875
      tv, [[[res * 0.5]], [[res * 0.75]], [[res]]], i * 140, 150, true = 3
      xyouts, i * 140 + 70, 154, dateStrings[i], color = 'ffcc66'XUL, $
              /device, alignment = 0.5, charsize = 0.875

      wset, h2_draw
      polyfill, [-1, -1, (i + 1) / filesN, (i + 1) / filesN], [-1, 2, 2, -1], $
                color = 'ffeecc'XUL, /normal
  endfor

  widget_control, w2_base, /destroy
end
