function v_, r, phi, theta
  return, [[r * sin(theta) * cos(phi)], $
           [r * sin(theta) * sin(phi)], $
           [r * cos(theta)]]
end

function dotP, v1, v2
  return, transpose(v1) # v2
end

function vlen, v
  return, sqrt(total(v ^ 2))
end

function angleBetween, v1, v2
  return, acos(dotp(v1, v2) / (vlen(v1) * vlen(v2)))
end

function mtrans, a, b, ap, bp
  mint1 = [[crossp(ap, bp)], [crossp(ap, crossp(ap, bp))], [ap]]
  mint2 = [[crossp(a, b)], [crossp(a, crossp(a, b))], [a]]
  return, transpose(mint1) ## mint2
end

function rotsum_findxy, Lre, thetaDeg ;minL and maglon
  @euv_imtool-commons
  @rotsum_common

  L = Lre
  theta = thetaDeg / 180.0D * !pi

  smFromMag = T4 ## T3 ## T2 ## transpose(T1) ## transpose(T5)
  mlonVect = [cos(theta), sin(theta), 0]
  mlonVect = smFromMag ## mlonVect

  theta = atan(mlonVect[1], mlonVect[0])


  rsm = [image_smx, image_smy, image_smz] / 6378

  ;print, 'rsm: ', rsm
  rsm_len = sqrt(rsm[0] ^ 2 + rsm[1] ^ 2 + rsm[2] ^ 2)

  sm_from_gci = double(t4##t3##t2)

  wsm = transpose(sm_from_gci ## [spin_axis_x, spin_axis_y, spin_axis_z])

  ;print, 'wsm: ', wsm
  wsm_len = sqrt(wsm[0] ^ 2 + wsm[1] ^ 2 + wsm[2] ^ 2)

  SMtoIM = mtrans((-wsm) / wsm_len, rsm / rsm_len, [1,0,0], [0,0,1])
  ;print, 'smtoim: ', smtoim

  equat = v_(L, theta, !pi / 2)
  k = equat[0] / equat[1]

  i = indgen(178) + 1.0D
  lambda = (i - 90) / 180.0D * !pi

  zf = L * sqrt(cos(lambda) ^ 4 - cos(lambda) ^ 6)
  zf_ind = where(zf lt 0)
  if zf_ind[0] ne -1 then zf[zf_ind] = -zf[zf_ind]
  
  ro = L * cos(lambda) ^ 3

  yf = sqrt((ro ^ 2) / (1 + k ^ 2))
  if equat[1] lt 0 then yf = -yf

  xf = k * yf

  f = [[xf], [yf], [zf]]

  sep = fltarr(n_elements(i))
  for j = 0, n_elements(i) - 1 do begin
      sep[j] = angleBetween(transpose(f[j, *]) - rsm, -rsm)
  endfor

  maxsep = max(-!pi > sep < !pi)
  maxsepIndex = where(sep eq maxsep)
  choose = maxsepIndex[0]

  ;print, 'msi: ', maxSepIndex
  ;print, 'choose: ', choose, maxsep / !pi * 180.0D, n_elements(sep)

  psm = transpose([[xf[choose]], [yf[choose]], [zf[choose]]])
  ;print, 'psm: ', psm
  pim = transpose(SMtoIM ## psm)
  ;print, 'pim: ', pim

  rim = [[0], [0], [vlen(rsm)]]
  
  fim = pim - rim
  d = vlen(fim)
  ;print, 'd: ', d

  alpha = asin(fim[0] / d)
  beta = asin(fim[1] / (d * cos(alpha)))

  ;print, 'alpha/beta: ', alpha / !pi * 180.0D, beta / !pi * 180.0D

  a = cir_x + alpha / !pi * 180 / 0.3D
  b = cir_y + beta / !pi * 180 / 0.3D

  return, [a, b]
end
