pro plotter_setupwidgets
  @plotter_common

  w_base  = widget_base(xsize = 855, ysize = 610)

  w_draw  = widget_draw(w_base, xsize = 560, ysize = 600, $
                        xoffset = 5, yoffset = 5, /button_events, $
                        uvalue = 'd_main')

  w_draw2 = widget_draw(w_base, xsize = 280, ysize = 300, $
                        xoffset = 570, yoffset = 5)

  w_date = widget_label(w_base, xsize = 180, ysize = 20, $
                        xoffset = 620, yoffset = 310, $
                        value = 'yyyy/ddd/hh:mm')

  w_prev = widget_button(w_base, xsize = 48, ysize = 20, $
                         xoffset = 570, yoffset = 310, $
                         value = 'Prev', sensitive = 0, $
                         uvalue = 'b_prev')

  w_next = widget_button(w_base, xsize = 48, ysize = 20, $
                         xoffset = 802, yoffset = 310, $
                         value = 'Next', sensitive = 0, $
                         uvalue = 'b_next')

  w_changetype = widget_button(w_base, xsize = 280, ysize = 24, $
                               xoffset = 570, yoffset = 335, $
                               value = 'Graph type: MLT', $
                               uvalue = 'b_settype')

  w_lines = widget_button(w_base, xsize = 138, ysize = 24, $
                          xoffset = 570, yoffset = 364, $
                          value = 'Radial lines: 12', $
                          uvalue = 'b_numlines')

  w_labels = widget_button(w_base, xsize = 138, ysize = 24, $
                           xoffset = 712, yoffset = 364, $
                           value = 'Tick labels: 4', $
                           uvalue = 'b_numlabels')

  w_slider = widget_slider(w_base, xsize = 190, ysize = 20, $
                           xoffset = 660, yoffset = 393, $
                           minimum = 2, maximum = 10, value = 5, $
                           uvalue = 'b_slider', /drag)

  w_distlabel = widget_label(w_base, ysize = 20, $
                             xoffset = 570, yoffset = 393, $
                             value = 'Max radius: 5 ', /align_left)
  
  w_write = widget_button(w_base, xsize = 280, ysize = 24, $
                          xoffset = 570, yoffset = 552, $
                          value = 'Save image', $
                          uvalue = 'b_saveimage')

  w_makeall = widget_button(w_base, xsize = 280, ysize = 24, $
                            xoffset = 570, yoffset = 581, $
                            value = 'Make graphs for all selected files', $
                            uvalue = 'b_makeall')

  widget_control, w_base, /realize

  widget_control, w_draw, get_value = h_draw
  widget_control, w_draw2, get_value = h_draw2

  window, 1, /pixmap, xsize = 560, ysize = 600
end
