pro plotter_plot, hardcopy = hardcopy
  @plotter_common
  @plotter_colors
  @euv_imtool-commons

  if n_elements(hardcopy) eq 0 then hardcopy = 0

  if not hardcopy then begin
      width = 560
      height = 600
      hc_sz = float(hc_height < hc_width)
      os_sz = float(height < width)
      charheight = fix(hc_titlesize / hc_sz * os_sz)
      smallcharheight = fix(hc_labelsize / hc_sz * os_sz)
  endif else begin
      width = hc_width
      height = hc_height
      charheight = hc_titlesize
      smallcharheight = hc_labelsize
  endelse

  radius = ((width - charheight * 2) < (height - charheight)) * 0.43

  bmult = charheight / 18.0D * 2.6
  smult = smallcharheight / 9.0D * 1.3

  xMid = fix(width / 2.0)
  yMid = fix((height - charheight)/ 2.0)

  if not hardcopy then wset, 1 else begin
      window, 5, /pixmap, xsize = width, ysize = height
  endelse

  polyfill, [-1, -1, 2, 2], [-1, 2, 2, -1], /normal, color = c_background

  circle, xMid, yMid, radius, color = c_innerbackground, filled = 1, linewidth = 4

  print, 'ymid: ', ymid
  radstep = radius / rdist

  if graphType eq 0 then begin
      xTitle = 'MLT'
      limit = 24
      shadowPos = 0
  endif else begin
      xTitle = 'Magnetic Longitude'
      limit = 360
      shadowPos = mlonArray[0] - mltArray[0] / 24.0 * 360
  endelse 

  shadowPos = shadowPos / 180.0D * !pi
;  line, xMid + radius * cos(shadowPos), $
;        yMid + radius * sin(shadowPos), $
;        xMid, yMid, linewidth = 5, color = 0

  step = 360.0D / lineFreq

  for angle = 0, 360, step do begin
      line, xMid + radstep * cos(angle / 180.0 * !pi), $
            yMid + radstep * sin(angle / 180.0 * !pi), $
            xMid + radius * cos(angle / 180.0 * !pi), $
            yMid + radius * sin(angle / 180.0 * !pi), $
            linewidth = lw_radiallines, color = c_radiallines
      line, xMid + 0 * cos(angle / 180.0 * !pi), $
            yMid + 0 * sin(angle / 180.0 * !pi), $
            xMid + radstep * cos(angle / 180.0 * !pi), $
            yMid + radstep * sin(angle / 180.0 * !pi), $
            linewidth = lw_radiallines, color = c_earthlines
      str = zeroPad(fix(angle / 360.0D * limit), 0)

      a = angle - 90
      x = 0
      if a gt 90 then begin
          a = a - 180
          x = smallcharheight
      endif
      
      if angle lt 360 and angle mod (360 / tickFreq) eq 0 $
                      and tickFreq gt 0 then $
;       xyouts, xMid + radius * 1.1 * cos(angle / 180.0 * !pi), $
;               yMid + radius * 1.075 * sin(angle / 180.0 * !pi) - $
;                                       smallcharheight * 0.5, $
;               str, color = c_labels, charsize = smult, $
;               orientation = 0, alignment = 0.5, /device, charthick = 2
        xyouts, xMid + (x + radius * 1.05) * cos(angle / 180.0 * !pi), $
                yMid + (x + radius * 1.05) * sin(angle / 180.0 * !pi), $
                str, color = c_labels, charsize = smult, $
                orientation = a, alignment = 0.5, /device, $
                charthick = scharthick
  endfor

  for i = 2, rdist - 1 do begin
      circle, xMid, yMid, i * radstep, linewidth = lw_innercircles, $
              smoothness = 128, color = c_circles
      circle, xMid + i * radstep * cos(larad), $
              yMid + i * radstep * sin(larad), $
              smallcharheight * 0.65, color = c_background, filled = 1
      xyouts, xMid + i * radstep * cos(larad) + 1, $
              yMid + i * radstep * sin(larad) - smallcharheight * 0.75 / 2, $
              zeroPad(i, 0), color = c_distlabels, alignment = 0.47, /device, $
              charsize = 0.8 * smult
      xyouts, xMid + i * radstep * cos(larad), $
              yMid + i * radstep * sin(larad) - smallcharheight * 0.75 / 2, $
              zeroPad(i, 0), color = c_distlabels, alignment = 0.47, /device, $
              charsize = 0.8 * smult
      circle, xMid + i * radstep * cos(larad), $
              yMid + i * radstep * sin(larad), $
              smallcharheight * 0.65, color = c_circles
  endfor

  circle, xMid, yMid, rdist * radstep + 1, linewidth = lw_outercircle, $
          smoothness = 128, color = c_outercircle

  datestr = zeroPad(s0year, 4) + '-' + zeroPad(s0doy, 3) + '/' + $
            zeroPad(s0hour, 2) + ':' + zeroPad(s0min, 2)

  xoff = fix(width * 0.015)

  xyouts, xoff + 2, height * 0.985 - charheight, dateStr, color = c_labels, $
          charsize = bmult, alignment = 0.0, /device
  xyouts, xoff + 1, height * 0.985 - charheight, dateStr, color = c_labels, $
          charsize = bmult, alignment = 0.0, /device
  xyouts, xoff, height * 0.985 - charheight, dateStr, color = c_labels, $
          charsize = bmult, alignment = 0.0, /device

  xoff = fix(width * 0.985)

  xyouts, xoff - 2, height * 0.985 - charheight, xTitle, color = c_labels, $
          charsize = bmult, alignment = 1.0, /device
  xyouts, xoff - 1, height * 0.985 - charheight, xTitle, color = c_labels, $
          charsize = bmult, alignment = 1.0, /device
  xyouts, xoff, height * 0.985 - charheight, xTitle, color = c_labels, $
          charsize = bmult, alignment = 1.0, /device

  circle, xMid, yMid, radstep, linewidth = 1, smoothness = 256, $
          color = c_earth, filled = 1

  if graphType eq 0 then begin
      xDisp = xMid + radstep * lArray * cos(mltArray / 12.0D * !pi)
      yDisp = yMid + radstep * lArray * sin(mltArray / 12.0D * !pi)
  endif else begin
      xDisp = xMid + radstep * lArray * cos(mlonArray / 180.0D * !pi)
      yDisp = yMid + radstep * lArray * sin(mlonArray / 180.0D * !pi)
  endelse
  start = 0
  for i = 1, arraySize - 1 do begin
      if cArray[i] eq 0 then begin
          plots, xDisp[start:(i - 1)], yDisp[start:(i - 1)], $
                 color = c_plotline, /device, thick = lw_graph
          plots, xDisp[start:(i - 1)], yDisp[start:(i - 1)], $
                 psym = icon_dots, symsize = sz_dots, color = c_plotdot, $
                 /device, thick = lw_dots
          start = i
      endif
  endfor
  plots, xDisp[start:(arraySize - 1)], yDisp[start:(arraySize - 1)], $
         color = c_plotline, /device, thick = lw_graph
  plots, xDisp[start:(arraySize - 1)], yDisp[start:(arraySize - 1)], $
         psym = icon_dots, symsize = sz_dots, color = c_plotdot, $
         /device, thick = lw_dots

  if not hardcopy then begin
      wset, h_draw
      device, copy = [0, 0, 560, 600, 0, 0, 1]
      
      wset, h_draw2
      tvscl, darray
      
      plots, xArray, yArray, /device, color = 'ffaa00'XUL, psym = 4, symsize = 0.333
      plots, xArray, yArray, /device, color = 'ffffff'XUL, psym = 3

      return
  endif

  arr = tvrd(true = 3)

  filename = clkList[curFile]

  if graphType eq 0 then type = 'mlt' else type = 'mlon'
  png = strmid(filename, 0, strpos(filename, '.', /reverse_search)) + '_' + type + '.png'

; ** SLOW but makes 8-bit png files
  total = arr[*, *, 0] + 256L * arr[*, *, 1] + 256 * 256L * arr[*, *, 2]
  t = intarr(width, height)
  r = intarr(n_elements(pal_plotter))
  g = intarr(n_elements(pal_plotter))
  b = intarr(n_elements(pal_plotter))
  for i = 0, n_elements(pal_plotter) - 1 do begin
      j = where(total eq pal_plotter[i])
      if j[0] ne -1 then t[j] = i else print, 'not found: ', i
      r[i] = fix(pal_plotter[i] mod '000100'XUL)
      g[i] = fix((pal_plotter[i] mod '010000'XUL) / '000100'XUL)
      b[i] = fix(pal_plotter[i] / '010000'XUL)
  endfor
  write_png, png, t, r, g, b

; ** STILL slow but makes big 24-bit png files
;  arr2 = transpose(arr, [2, 0, 1])
;  write_png, png, arr2
end
