pro avg
  get_lun, f
  get_lun, ff
  openr, f, '../2002180-2002351.txt'
  openw, ff, 'averages.txt'

  printf, ff, '   julian day    counts    x   y cam   phase     range     bkgnd  nspins'

  tmp = ''
  readf, f, tmp
  readf, f, tmp

  lastjd = 0
  cnt = 0
  jul = 0D
  jultotal = 0D
  phasetotal = 0D
  xcentertotal = 0D
  ycentertotal = 0D
  avgtotal = 0D
  rangetotal = 0D
  bgavgtotal = 0D
  while not eof(f) do begin
      date_str = ''
      readf, f, format = '(I4, F9.3, F14.4, F8.2, F10.1, I5, I5, F8.2, ' + $
             'F8.2, F9.3, F8.3, I6, I6, A2, A14)', $
             date_year, date_doy, jul, phase, range, x, y, xcenter, ycenter, avg, bgavg, $
             count1, count2, tmp, date_str
      if eof(f) then begin
          jultotal = jultotal + jul
          phasetotal = phasetotal + phase
          xcentertotal = xcentertotal + xcenter
          ycentertotal = ycentertotal + ycenter
          avgtotal = avgtotal + avg * count1
          bgavgtotal = bgavgtotal + bgavg
          rangetotal = rangetotal + range
          cnt = cnt + 1
          last_str = date_str
      end
      if (jul - lastjd) gt 0.25 or eof(f) then begin
          if cnt gt 0 then begin
              julavg = jultotal / cnt
              phaseavg = phasetotal / cnt
              xcenteravg = xcentertotal / cnt
              ycenteravg = ycentertotal / cnt
              avgavg = avgtotal / cnt
              rangeavg = rangetotal / cnt
              bgavgavg = bgavgtotal / cnt
              xpos = xcenteravg mod 50
              camera = floor((150 - xcenteravg) / 50)
              printf, ff, format = '(F13.4, F10.2, I5, I4, I4, F8.2, F10.1, F10.2, I4)', $
                      julavg, avgavg, xpos, ycenteravg, camera, phaseavg, rangeavg, $
                      bgavgavg, cnt
          end
          start_str = date_str
          cnt = 0
          jultotal = 0D
          phasetotal = 0D
          xcentertotal = 0D
          ycentertotal = 0D
          avgtotal = 0D
          rangetotal = 0D
          bgavgtotal = 0D
      end
      cnt = cnt + 1
      lastjd = jul
      last_str = date_str
      jultotal = jultotal + jul
      phasetotal = phasetotal + phase
      xcentertotal = xcentertotal + xcenter
      ycentertotal = ycentertotal + ycenter
      avgtotal = avgtotal + avg * count1
      bgavgtotal = bgavgtotal + bgavg
      rangetotal = rangetotal + range
  end          
          
  close, ff
  close, f
  free_lun, ff
  free_lun, f
end
