# THIS procedure outputs VIDF value arrays

package provide VEDIT 1.0

proc VEsaveArray { fd Field nV { Force YES } { Elem -1 } } {
   global env veANS ViDF 

   if { $Elem < 0 } { set FiD $Field } else { set FiD $Field,$Elem }

   if {[string compare TBL $Field] == 0 } {
      if { $ViDF(TBLTYPE,$Elem) == 1 } { set dQ YES } else { set dQ NO }
   } else { set dQ NO }

   if ![info exists veANS($FiD.W)] {
      if [info exists ViDF($FiD)] {
         set veANS(cText) $ViDF($FiD) 
         set nE [llength $ViDF($FiD)]
      } else { set nE 0 }
   } else { set nE [VEreadText $veANS($FiD.W) YES $dQ] }

   if [string match YES $Force] {
      if { $nV != $nE } {
         VEgiveWarning 5 $FiD $nE $nV
         close $fd
         return 0
      }
   }

   if { $nE > 0 } {
      set Parms [VEarrayFit veANS(cText)]
      set P   [lindex $Parms 1]
      set Fmt [lindex $Parms 2]

# LOOP over the elements, format them, and output them.  There are two
#   blank spaces leading off each line except the first which has only
#   one

      if { $nE < $P } { set nI $nE } else { set nI $P }
      puts $fd "m $nE $nI"
      set fmT "[VEfieldSize $Field $Elem][string range $Fmt 1 end]"
      for { set I 0 ; set J 1 } { $I < $nE } { incr I ; incr J } {
         if { [expr $I % $P] == 0 } { 
            set V [format $fmT [lindex $ViDF($FiD) $I]]
         } else { set V [format $Fmt [lindex $ViDF($FiD) $I]] }
         puts -nonewline $fd $V
         if { [expr $J % $P] == 0 } { puts -nonewline $fd "\n" }
      }
      if { [expr $I % $P] != 0 } { puts -nonewline $fd "\n" }
   } else { puts $fd n }

   return 1
}
