# THIS procedure rebuilds VIDFs
                                                                                
package provide VEDIT 1.0
                                                                                
proc VErebuildEntries { UdF Add eList { vSrc 0 } } {
   global env veANS ViDF VFields UDFPaths

   upvar $UdF U
   upvar $eList eL

   set vDir $U(P).$U(M).$U(E).$U(I)
   if { $vSrc == 0 } {
      set nE [llength $Add]
      for { set I 0 } { $I < $nE } { incr I } {
         set eF [split [lindex $Add $I]]
         set vN [lindex $eF 0]
         set tM [lindex $eF 1]
         scan $tM "%7s%s" YD Ms
         set Ms [string trimleft $Ms "0"]
         if { [string length $Ms] == 0 } { set Ms 0 }
         set H [expr int($Ms / 3600000)]
         set M [expr int(($Ms % 3600000) / 60000 )]
         set HM [format "%02d%02d" $H $M]
         lappend eL($vDir) $vN$YD$HM
      }
   } else {
      set P [lsearch -glob -all $Add ${U(V)}*]
      set nP [llength $P]

      set sL [string length $U(V)]
      for { set I 0 } { $I < $nP } { incr I } {
         set vName [lindex $Add [lindex $P $I]]
	 set NextC [string index $vName $sL]
         if [regexp {^[+-]?[0-9]+$} $NextC] { lappend eL($vDir) $vName }
      }
   }
}
