# THIS procedure reads and ascii VIDF  file
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEreadVidfV { vName } {
   global env veANS ViDF VFields

   if ![file exists $vName] {
      VEgiveWarning 4 $vName
      return 0
   }

   if [catch {open $vName r} fa ] {
      VEgiveWarning 3 $vName
      return 0
   }

#  Determine how many fields there are in the VIDF base, table, and
#    constants sections.

   set nBF [lsearch -exact $VFields TBLSCASZ]  
   set nTF [expr [lsearch -exact $VFields CONSTID] - $nBF] 
   set nCF [expr [lsearch -exact $VFields CONST] - \
                       [lsearch -exact $VFields CONSTID] + 1] 

# CHECK to see if there is a Version line in the VIDF.  If there isn't
#   a version line set it to and reset the ASCII file pointer to the 
#   start of the file.

   gets $fa vLine
   set vOuT [DBvidfLineParse $vLine]
   if { [lindex $vOuT 0] == "V" } {
      set ViDF(VERSION) [string trimleft [lindex $vOuT 1]]
   } else { 
      TUfileSeek $fa 0 start 
      set ViDF(VERSION) V2.1
   }

# READ the base VIDF fields (all fields down to the start of the table
#   definitions)

   for { set I 0 } { $I < $nBF } { incr I } { 
      set fID [lindex $VFields $I]
      VEprocTxTField $fa $fID
   }


# FIND is the number of table definitions in the VIDF and the number of
#   fields in a table definition

   set nT $ViDF(NUMTBLS)
   set tBeG [lsearch -exact $VFields TBLSCASZ]  

# LOOP through the base VIDF tables 

   for { set I 0 } { $I < $nT } { incr I } { 
      for { set J 0 ; set K $tBeG } { $J < $nTF } { incr J ; incr K } { 
         set fID [lindex $VFields $K],$I
         VEprocTxTField $fa $fID
      }
      if { $ViDF(TBLTYPE,$I) == 1 } {
         set TmP $ViDF(TBL,$I)
         set nE [llength $TmP]
         set ViDF(TBL,$I) ""
         for {set J 0} {$J < $nE} {incr J} {
            lappend ViDF(TBL,$I) \"[lindex $TmP $J]\"
         } 
      }
   }

   set nC $ViDF(NUMCONSTS)
   set cBeG [lsearch -exact $VFields CONSTID]  

   for { set I 0 } { $I < $nC } { incr I } { 
      for { set J 0 ; set K $cBeG } { $J < $nCF } { incr J ; incr K } { 
         set fID [lindex $VFields $K],$I
         VEprocTxTField $fa $fID
      }
   }

   close $fa

   return 1
}
