# THIS procedure displays the VIDF sensor information
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEguiSensor { } {
   global env veANS ViDF VFields
                                                                                
   set W   .veSensor
   if { [winfo exists $W] == 0 } {
      toplevel $W

      set Wa $W.top
      set Wb $W.info
      set Wd $W.wlens
      set We $W.types
      set Wf $W.toffs
      set Wg $W.stat

      GUIFrame $Wa -1 pack|top||both|true
      GUIFrame $Wb 0 pack|top||both|true
      GUIFrame $Wd 0 pack|top||both|true
      GUIFrame $We 0 pack|top||both|true
      GUIFrame $Wf 0 pack|top||both|true
      GUIFrame $Wg 0 pack|top||both|true

      set Y [VEboxSize SENSOR Parms 0 ParmsEx]

      set daMopts [list Continuous|0 "Full Discontinuous|1" \
                    "Partial Discontinuous|2" Blocked|3 ]

      GUILabel $Wa.tit "$veANS(0,V) SENSOR DATA" w pack|left|w|x|true \
                  6 30 "" [list times 16 bold]
      GUIbuttonPush $Wa.close CLOSE pack|right "wm withdraw $W" 6

      GUILabel $Wb.ln "NUMBER" w grid|0|0|w 4 15
      GUIboxEntry $Wb.dn grid|0|1|w 10 ViDF(SEN) "" $veANS(nFonT)

      GUILabel $Wb.ll "ARRAY LENGTH" w grid|1|0|w 4 15
      GUIboxEntry $Wb.dl grid|1|1|w 10 ViDF(SWPLEN) "" $veANS(nFonT)
			     
      GUILabel $Wb.lt "ARRAY TIMING" w grid|2|0|w 4 15
      set Label [lindex [split [lindex $daMopts $ViDF(DAMETHOD)] "|"] 0]
      GUIbuttonMenu $Wb.dt "$Label" grid|2|1|w $daMopts \
            "GUIoptsProcess .veSensor.info.dt veANS(DAMETHOD) ALT " 6

      GUILabel $Wb.ls "DESCRIPTION" w grid|3|0|n 4 15
      GUIboxText $Wb.ds 80 [lindex $Y 0] grid|3|1 0 1 $veANS(bFonT)
      VEarrayTOut $Wb.ds SENNAME

      GUILabel $Wd.la "BIT LENGTHS" w grid|0|0|n 4 15
      GUIboxText $Wd.da 80 [lindex $Y 1] grid|0|1 0 1 $veANS(bFonT)
      VEarrayOut $Wd.da $Parms TDWLEN

      GUILabel $We.la "FORMATS" w grid|0|0|n 4 15
      GUIboxText $We.da 80 [lindex $Y 2] grid|0|1 0 1 $veANS(bFonT)
      VEarrayOut $We.da $Parms DATATYPE

      GUILabel $Wf.la "TIME OFFSETS" w grid|0|0|n 4 15
      GUIboxText $Wf.da 80 [lindex $Y 3] grid|0|1 0 1 $veANS(bFonT)
      VEarrayOut $Wf.da $Parms TIMEOFF

      GUILabel $Wg.la "STATUS" w grid|0|0|n 4 15
      GUIboxText $Wg.da 80 [lindex $Y 4] grid|0|1 0 1 $veANS(bFonT)
      VEarrayOut $Wg.da $Parms SENSTATUS
   } else {
      if [string match withdrawn [wm state $W]] { wm deiconify $W }
   }
}
