# THIS procedure displays the VIDF ancillary information
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEguiAncillary { } {
   global env veANS ViDF VFields
                                                                                
   set W   .veAnc
   if { [winfo exists $W] == 0 } {
      toplevel $W

      set Wa $W.top
      set Wb $W.info
      set Wc $W.wlens
      set Wd $W.use
      set We $W.targ

      GUIFrame $Wa -1 pack|top||both|true
      GUIFrame $Wb 0 pack|top||both|true
      GUIFrame $Wc 0 pack|top||both|true
      GUIFrame $Wd 0 pack|top||both|true
      GUIFrame $We 0 pack|top||both|true

      set Y [VEboxSize ANCILLARY Parms 0 ParmsEx] 

      GUILabel $Wa.tit "$veANS(0,V) ANCILLARY DATA" w pack|left|w|x|true \
                  6 30 "" [list times 16 bold]
      GUIbuttonPush $Wa.close CLOSE pack|right "wm withdraw $W" 6

      GUILabel $Wb.ln "NUMBER" w grid|0|0|w 4 15
      GUIboxEntry $Wb.dn grid|0|1|w 10 ViDF(CALSETS) "" $veANS(nFonT)

      GUILabel $Wb.ls "DESCRIPTION" w grid|3|0|n 4 15
      GUIboxText $Wb.ds 80 [lindex $Y 0] grid|3|1 0 1 $veANS(bFonT)
      VEarrayTOut $Wb.ds CALNAMES

      GUILabel $Wc.la "BIT LENGTHS" w grid|0|0|n 4 15
      GUIboxText $Wc.da 80 [lindex $Y 1] grid|0|1 0 1 $veANS(bFonT)
      VEarrayOut $Wc.da $Parms CALWLEN

      GUILabel $Wd.la "USAGE" w grid|0|0|n 4 15
      GUIboxText $Wd.da 80 [lindex $Y 2] grid|0|1 0 1 $veANS(bFonT)
      VEarrayOut $Wd.da $Parms CALUSE

      GUILabel $We.la "TARGET" w grid|0|0|n 4 15
      GUIboxText $We.da 80 [lindex $Y 3] grid|0|1 0 1 $veANS(bFonT)
      VEarrayOut $We.da $Parms CALTARGET

   } else {
      if [string match withdrawn [wm state $W]] { wm deiconify $W }
   }
}
