# THIS procedure collapses the array of tables when one of the
#   tables has been deleted.
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEcollapseTable { tN  } {
   global env veANS ViDF VFields UDFPaths

# THIS is the collapse loop

   set nT [expr $tN + 1]
   set EnD $ViDF(NUMTBLS)
   
   set begT [lsearch -exact $VFields TBLSCASZ]
   set endT [lsearch -exact $VFields TBL]

   for { set I  } { $I < $ViDF(NUMTBLS) } { incr I } { 
      if { ($ViDF(TBLVAR,$I) ==4) || ($ViDF(TBLVAR,$I) ==5) } {
         set dL $ViDF(STATUS)
      } else { set dL $ViDF(SEN) }
      VEsaveItem $fo TBLSCASZ TBLDESCLEN $I
      if ![VEsaveText $fo TBLDESC $ViDF(TBLDESCLEN,$I) YES $I] { return 0 }
      VEsaveItem $fo TBLVAR CRITACTSZ $I
      if ![VEsaveArray $fo CRITSTATUS $ViDF(CRITACTSZ,$I) YES $I] { return 0 }
      if ![VEsaveArray $fo CRITOFF $ViDF(CRITACTSZ,$I) YES $I] { return 0 }
      if ![VEsaveArray $fo CRITACTION $ViDF(CRITACTSZ,$I) YES $I] { return 0 }
      if ![VEsaveArray $fo TBLFMT $dL YES $I] { return 0 }
      if ![VEsaveArray $fo TBLOFF $dL YES $I] { return 0 } 
      if ![VEsaveArray $fo TBLSCA [expr abs($ViDF(TBLSCASZ,$I))] YES $I] { 
         return 0 
      }
      if ![VEsaveArray $fo TBL [expr abs($ViDF(TBLELESZ,$I))] YES $I] { 
         return 0 
      }
   }

   for { set I 0 } { $I < $ViDF(NUMCONSTS) } { incr I } { 
      VEsaveItem $fo CONSTID CONSTDESCLEN $I
      if ![VEsaveText $fo CONSTDESC $ViDF(CONSTDESCLEN,$I) YES $I] { return 0 }
      if ![VEsaveArray $fo CONSTSCA $ViDF(SEN) YES $I] { return 0 }
      if ![VEsaveArray $fo CONST $ViDF(SEN) YES $I] { return 0 }
   }
   
   close $fo

   set veANS(VIDFsaved) 1

   if { $veANS(ReBld) } {
      set tName [file join $UDFPaths(2) ${bName}I]
      DBvidfToBinary $vName
      if ![file exists $iName] { 
         VEgiveWarning 6 $iName
         return 0 
      }

      set dbE [file join $UDFPaths(1) I.asc]
      set dBdbf [file join $UDFPaths(1) $veANS(0,I).I.DBF]
      set dBndx [file join $UDFPaths(1) $veANS(0,I).I.NDX]

      set Pos [DBfileDup $dBdbf dB $bName]
      set dLen [llength $Pos]
      for { set J 0 } { $J < $dLen } { incr J } {
         set dBKey [list [lindex $dB(KeyList) [lindex [lindex $Pos $J] 1]]]
         DBdbfDelete $dBdbf [lindex [lindex $Pos $J] 0]
         DBndxDelete $dBndx $dBKey
      }

      if [file exists $iName] { file rename -force $iName $tName }
      DBgenEntries I $UDFPaths(2) $UDFPaths(2) $dbE ${bName}I
      set ePos [DBdbfAppend $dBdbf $dbE]
      DBndxAppend $dBndx $dbE $ePos
      file delete -force $dbE
   }
 
   return 1
}
