# THIS procedure displays the VIDF header information
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEcheckVIDF { } {
   global env veANS ViDF VFields UDFPaths GUIwaitVar

   VEsetDescLens

   set MsGs ""

   if { $ViDF(PADEFINED) == 1 } {
      if { [string length $ViDF(PAFORMAT)] == 0 } { 
         lappend MsGs "PAFORMAT: unset with PAFORMAT set"
      }
      if { [string length $ViDF(PAPROJECT)] == 0 } { 
         lappend MsGs "PAPROJECT: unset with PAFORMAT set"
      }
      if { [string length $ViDF(PAMISSION)] == 0 } { 
         lappend MsGs "PAMISSION: unset with PAFORMAT set"
      }
      if { [string length $ViDF(PAEXPER)] == 0 } { 
         lappend MsGs "PAEXPER: unset with PAFORMAT set"
      }
      if { [string length $ViDF(PAINST)] == 0 } { 
         lappend MsGs "PAINST: unset with PAFORMAT set"
      }
      if { [string length $ViDF(PAVINST)] == 0 } { 
         lappend MsGs "PAVINST: unset with PAFORMAT set"
      }
      VEcheckArray PABXBYBZ 3 MsGs
      if { [string length $ViDF(PAAPPS)] == 0 } { 
         lappend MsGs "PAAPPS: unset with PAFORMAT set"
      }
      VEcheckArray PATBLS $ViDF(PAAPPS) MsGs
      VEcheckArray PAOPS $ViDF(PAAPPS) MsGs
   }

   VEcheckArray DATATYPE $ViDF(SEN) MsGs 
   VEcheckArray TDWLEN $ViDF(SEN) MsGs
   VEcheckArray SENSTATUS $ViDF(SEN) MsGs
   VEcheckArray TIMEOFF $ViDF(SEN) MsGs
   VEcheckArray CALUSE $ViDF(CALSETS) MsGs
   VEcheckArray CALWLEN $ViDF(CALSETS) MsGs
   VEcheckArray CALTARGET $ViDF(CALSETS) MsGs

   for { set I 0 } { $I < $ViDF(NUMTBLS) } { incr I } { 
      if { ($ViDF(TBLVAR,$I) ==4) || ($ViDF(TBLVAR,$I) ==5) } {
         set dL $ViDF(STATUS)
      } else { set dL $ViDF(SEN) }
      if ![info exists ViDF(TBLSCASZ,$I)] { 
         lappend MsGs "TBLSCASZ,$I: undefined"
      }
      if ![info exists ViDF(TBLELESZ,$I)] { 
         lappend MsGs "TBLELESZ,$I: undefined"
      }
      if ![info exists ViDF(TBLTYPE,$I)] { 
         lappend MsGs "TBLTYPE,$I: undefined"
      }
      VEcheckText TBLDESC $ViDF(TBLDESCLEN,$I) MsGs $I
      if ![info exists ViDF(TBLVAR,$I)] { 
         lappend MsGs "TBLVAR,$I: undefined"
      }
      if ![info exists ViDF(TBLEXPAND,$I)] { 
         lappend MsGs "TBLEXPAND,$I: undefined"
      }
      if ![info exists ViDF(CRITACTSZ,$I)] { 
         lappend MsGs "CRITACTSZ,$I: undefined"
      }
      
      VEcheckArray CRITSTATUS $ViDF(CRITACTSZ,$I) MsGs $I
      VEcheckArray CRITOFF $ViDF(CRITACTSZ,$I) MsGs $I
      VEcheckArray CRITACTION $ViDF(CRITACTSZ,$I) MsGs $I
      VEcheckArray TBLFMT $dL MsGs $I
      VEcheckArray TBLOFF $dL MsGs $I 
      VEcheckArray TBLSCA [expr abs($ViDF(TBLSCASZ,$I))] MsGs $I
      VEcheckArray TBL [expr abs($ViDF(TBLELESZ,$I))] MsGs $I
   }

   for { set I 0 } { $I < $ViDF(NUMCONSTS) } { incr I } { 
      if ![info exists ViDF(CONSTID,$I)] { 
         lappend MsGs "CONSTID,$I: undefined"
      }
      VEcheckText  CONSTDESC $ViDF(CONSTDESCLEN,$I) MsGs $I
      VEcheckArray CONSTSCA $ViDF(SEN) MsGs $I
      VEcheckArray CONST $ViDF(SEN) MsGs $I
   }

   set nL [llength $MsGs]

   set W .checkit
   if [winfo exists $W] { destroy $W } 

   toplevel $W
   set Wm $W.top
   set We $W.bot
   GUIFrame $Wm -1 pack|top||both|true
   GUIFrame $We -1 pack|top||both|true

   set nL [llength $MsGs]
   if { $nL < 12 } {
      set FonT [list fixed 14 bold]
      GUIboxText $Wm.msg 40 [expr $nL + 3] pack|top||x|true 0 0 $FonT
   } else {
      GUIboxText $Wm.msg 40 15 pack|top||x|true 0 1
   }

   if { $nL == 0 } {
      $Wm.msg insert end "\n"
      $Wm.msg insert end "NO ERRORS ENCOUNTERED IN CHECK"
   } else {
      set OuT "CHECK RESULTS:\n\n"
      $Wm.msg insert end $OuT
      $Wm.msg tag configure bold -font [list fixed 12 bold]
      $Wm.msg tag configure reg  -font [list fixed 12]
      for { set I 0 } { $I < $nL } { incr I } {
         if { [expr $I % 2] == 0 } { set TaG bold } else { set TaG reg }
         set OuT [lindex $MsGs $I]\n
         $Wm.msg insert end $OuT $TaG
      }
   }
           
   GUIbuttonPush $We.ok OK grid|0|0 "destroy $W" 10

   raise $Wm.msg
   update
}
