# THIS procedure returns the number of lines of text and the maximum number
#    of entries per line to use when outputting an array VIDF field
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEarrayFit { iTem } {
   global env veANS

   upvar $iTem V

   if ![info exists V] { 
      return [list 0 1 "  %5s" 1]
   } else {
      set nE [llength $V]
      if { $nE == 0 } { return [list 0 1 "  %5s" 1] }
   }

#FIND the maximum array element length

   set MaxL -1
   for { set I 0 } { $I < $nE } {incr I} {
      set Len [string length [lindex $V $I]]
      if { $Len > $MaxL } {set MaxL $Len }
   }
		                                                                                      
# THIS is how many elements with we can fit across the text box assuming an
#   80 character text box with two spaces between each entry

   set P [expr int(80/($MaxL + 2))]

# THIS is how many lines of text we will output

   set Lines [expr $nE / $P]
   if { [expr $nE % $P] > 0 } { incr Lines }

# THIS is the format to use when outputting the elements

   set Fmt "  %${MaxL}s"

# SAVE the number of elements which can be output on a line.  Use this when
#  writing the Vidf back out to compute the array specification line

   return [list $Lines $P $Fmt $MaxL]
}
