# THIS procedure displays the VIDF header information
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEsaveVIDF { } {
   global env veANS ViDF VFields UDFPaths

# BUILD the file name.  If there is already one out there then rename it
#   to same name .save

   set vN $veANS(0,V)
   set Yr $ViDF(DSYEAR)
   set Dy $ViDF(DSDAY)
   set Hr [expr int($ViDF(DSMSEC) / 3600000)]
   set Mn [expr int(($ViDF(DSMSEC) % 3600000) / 60000 )]
   set bName [format "$vN%4d%03d%02d%02d" $Yr $Dy $Hr $Mn]

   set vName [file join $env(UDF_DATA) $veANS(0,P) $veANS(0,M) VIDFS ${bName}V]
   set iName [file join $env(UDF_DATA) $veANS(0,P) $veANS(0,M) VIDFS ${bName}I]

   if [file exists $vName] { file rename -force $vName ${vName}.save }

   if [catch {open $vName w} fo ] {
      VEgiveWarning 3 $vName
      return 0
   }

   VEsetDescLens

   if { [string first " " $ViDF(VERSION)] == 0 } {
      puts $fo "V [string range $ViDF(VERSION) 1 end]"
   } else { puts $fo "V $ViDF(VERSION)" } 

   VEsaveItem $fo PROJECT INSTDESC
   VEsaveText $fo CONTACT 5
   VEsaveItem $fo NUMCOMNTS NUMCOMNTS
   VEsaveText $fo COMMENTS $ViDF(NUMCOMNTS)
   VEsaveItem $fo DSYEAR FILLFLAG

   if { $ViDF(FILLFLAG) == 0 } {
      puts $fo "n"
      VEsaveItem $fo DAMETHOD DAMETHOD
   } else { VEsaveItem $fo FILL DAMETHOD }

   VEsaveText  $fo STATUSNAME $ViDF(STATUS)
   VEsaveArray $fo STATES $ViDF(STATUS)
   VEsaveText  $fo SENNAME $ViDF(SEN)
   VEsaveText  $fo CALNAMES $ViDF(CALSETS)
   VEsaveText  $fo QUALNAME $ViDF(NUMQUAL)

   if { $ViDF(PADEFINED) == 1 } {
      VEsaveItem $fo PAFORMAT PAVINST
      VEsaveArray $fo PABXBYBZ 3
      VEsaveItem $fo PAAPPS PAAPPS
      VEsaveArray $fo PATBLS $ViDF(PAAPPS)
      VEsaveArray $fo PAOPS $ViDF(PAAPPS)
   } else {
      for { set I 0 } { $I < 10 } { incr I } { puts $fo n }
   }

   VEsaveArray $fo DATATYPE $ViDF(SEN)
   VEsaveArray $fo TDWLEN $ViDF(SEN)
   VEsaveArray $fo SENSTATUS $ViDF(SEN)
   VEsaveArray $fo TIMEOFF $ViDF(SEN)
   VEsaveArray $fo CALUSE $ViDF(CALSETS)
   VEsaveArray $fo CALWLEN $ViDF(CALSETS)
   VEsaveArray $fo CALTARGET $ViDF(CALSETS)

   for { set I 0 } { $I < $ViDF(NUMTBLS) } { incr I } { 
      if { ($ViDF(TBLVAR,$I) ==4) || ($ViDF(TBLVAR,$I) ==5) } {
         set dL $ViDF(STATUS)
      } else { set dL $ViDF(SEN) }
      VEsaveItem $fo TBLSCASZ TBLDESCLEN $I
      if ![VEsaveText $fo TBLDESC $ViDF(TBLDESCLEN,$I) YES $I] { return 0 }
      VEsaveItem $fo TBLVAR CRITACTSZ $I
      if ![VEsaveArray $fo CRITSTATUS $ViDF(CRITACTSZ,$I) YES $I] { return 0 }
      if ![VEsaveArray $fo CRITOFF $ViDF(CRITACTSZ,$I) YES $I] { return 0 }
      if ![VEsaveArray $fo CRITACTION $ViDF(CRITACTSZ,$I) YES $I] { return 0 }
      if ![VEsaveArray $fo TBLFMT $dL YES $I] { return 0 }
      if ![VEsaveArray $fo TBLOFF $dL YES $I] { return 0 } 
      if ![VEsaveArray $fo TBLSCA [expr abs($ViDF(TBLSCASZ,$I))] YES $I] { 
         return 0 
      }
      if ![VEsaveArray $fo TBL [expr abs($ViDF(TBLELESZ,$I))] YES $I] { 
         return 0 
      }
   }

   for { set I 0 } { $I < $ViDF(NUMCONSTS) } { incr I } { 
      VEsaveItem $fo CONSTID CONSTDESCLEN $I
      if ![VEsaveText $fo CONSTDESC $ViDF(CONSTDESCLEN,$I) YES $I] { return 0 }
      if ![VEsaveArray $fo CONSTSCA $ViDF(SEN) YES $I] { return 0 }
      if ![VEsaveArray $fo CONST $ViDF(SEN) YES $I] { return 0 }
   }
   
   close $fo

   set veANS(VIDFsaved) 1

   if { $veANS(ReBld) } {
      set tName [file join $UDFPaths(2) ${bName}I]
      DBvidfToBinary $vName
      if ![file exists $iName] { 
         VEgiveWarning 6 $iName
         return 0 
      }

      set dbE [file join $UDFPaths(1) I.asc]
      set dBdbf [file join $UDFPaths(1) $veANS(0,I).I.DBF]
      set dBndx [file join $UDFPaths(1) $veANS(0,I).I.NDX]

      set Pos [DBfileDup $dBdbf dB $bName]
      set dLen [llength $Pos]
      for { set J 0 } { $J < $dLen } { incr J } {
         set dBKey [list [lindex $dB(KeyList) [lindex [lindex $Pos $J] 1]]]
         DBdbfDelete $dBdbf [lindex [lindex $Pos $J] 0]
         DBndxDelete $dBndx $dBKey
      }

      if [file exists $iName] { file rename -force $iName $tName }
      DBgenEntries I $UDFPaths(2) $UDFPaths(2) $dbE ${bName}I
      set ePos [DBdbfAppend $dBdbf $dbE]
      DBndxAppend $dBndx $dbE $ePos
      file delete -force $dbE
   }
 
   return 1
}
