# THIS procedure rebuilds VIDFs
                                                                                
package provide VEDIT 1.0
                                                                                
proc VErebuildVIDF { } {
   global env veANS ViDF VFields UDFPaths SySCmDs
                                                                                
#  THERE are two ways to build the VIDFS.  If we are building for the ASCII
#    souce then we build all files in the VIDFS directory which match the
#    PMEIV.  If we are building from Binary, then we rebuild all the binary 
#    files which match the PMEIV and time constraints.  The difference is
#    that ASCII rebuilds will build VIDFS which have not been built before
#    and BINRAY rebuilds will only build previously built files (it checks
#    the current database).

   if { [string compare BSRC $veANS(vSrc)] == 0 } { 
        set VSrc 0
   } else { set VSrc 1 }

   set U(P) "" ; set U(M) "" ; set U(E) "" ; set U(I) "" ; set U(V) ""
   set BlK 0
   set rList($BlK) ""

   if { $VSrc == 0 } {

# BINARY builds can take advantage of the time range

      set bY  100;  set bD 1 ; set bH 0 ; set bM 0 ; set bS 0;
      set eY 9000;  set eD 1 ; set eH 0 ; set eM 0 ; set eS 0;
      if ![string match YEAR $veANS(yRb)] { set bY $veANS(yRb) }
      if ![string match DAY  $veANS(dYb)] { set bD $veANS(dYb) }
      if ![string match HR   $veANS(hRb)] { set bH $veANS(hRb) }
      if ![string match MIN  $veANS(mNb)] { set bM $veANS(mNb) }
      if ![string match SEC  $veANS(sCb)] { set bS $veANS(sCb) }
      if ![string match YEAR $veANS(yRe)] { set eY $veANS(yRe) }
      if ![string match DAY  $veANS(dYe)] { set eD $veANS(dYe) }
      if ![string match HR   $veANS(hRe)] { set eH $veANS(hRe) }
      if ![string match MIN  $veANS(mNe)] { set eM $veANS(mNe) }
      if ![string match SEC  $veANS(sCe)] { set eS $veANS(sCe) }
      set bMsec [expr 3600000 * $bH + 60000 * $bM + 1000 * $bS]
      set eMsec [expr 3600000 * $eH + 60000 * $eM + 1000 * $eS]
   } else {

# ASCII builds will use whatever files the find in the VIDF directory

      set dHome $env(UDF_DATA)
      set diR [file join $dHome $veANS(0,P)]
      set diR [file join $diR $veANS(0,M)]
      set vDir [file join $diR VIDFS]
      set vFiles [exec $SySCmDs(ls) $vDir]
      set nP [llength $vFiles]
                                                                                
      set aVList ""
      for { set I 0 } { $I < $nP } { incr I } {
         set vName [lindex $vFiles $I]
         if { [string index $vName end] == "V" } { 
            set EnD [expr [string length $vName] - 2]
            lappend aVList [string range $vName  0 $EnD]
         }
      }
   }

   if [info exists veANS(MinQ)] {
      set PV [list P M E I V]
      set pLen [llength [split $veANS(MinQ) "."]]
      for { set I 0 } { $I < $pLen } { incr I } {
         set ChK [string trim $veANS(0,[lindex $PV $I])]
         if { [string length $ChK] == 0 } { return }
      }
   }

   set pList [VEudfLLimits pB pE U $veANS(0,P)] 
   for { set P $pB } { $P < $pE } { incr P } {
      set U(P) [lindex $pList $P]
      set mList [VEudfLLimits mB mE U $veANS(0,M)] 
      for { set M $mB } { $M < $mE } { incr M } {
         set U(M) [lindex $mList $M]
         set eList [VEudfLLimits eB eE U $veANS(0,E)] 
         for { set E $eB } { $E < $eE } { incr E } {
            set U(E) [lindex $eList $E]
            set New 1
            set iList [VEudfLLimits iB iE U $veANS(0,I)] 
            for { set I $iB } { $I < $iE } { incr I } {
               set U(I) [lindex $iList $I]
               set vList [VEudfLLimits vB vE U $veANS(0,V)] 
               for { set V $vB } { $V < $vE } { incr V } {
                  set U(V) [lindex $vList $V]
                  if { $VSrc == 0 } {
                     set KeY [GetDataKey $U(P) $U(M) $U(E) $U(I) $U(V)]
                     set rV  [DBgetEntries $KeY $bY $bD $bM $eY $eD $eM I 1]
                      VErebuildEntries U $rV VFiles $VSrc
                  } else { VErebuildEntries U $aVList VFiles $VSrc }
               }
               set U(V) ""
            }
            set U(I) ""
         }
         set U(E) ""
      }
      set U(M) ""
   }

   set gL [array names VFiles] 
   set gLen [llength $gL]
   
   set dDir $env(UDF_DATA)
   for { set I 0 } { $I < $gLen } { incr I } {
      set Index [lindex $gL $I]
      set U(P) [lindex [split $Index "."] 0]
      set U(M) [lindex [split $Index "."] 1]
      set U(E) [lindex [split $Index "."] 2]
      set U(I) [lindex [split $Index "."] 3]
      UDFdirPaths $U(P) $U(M) $U(E) $U(I)

      set fList ""
      set vD [file join $env(UDF_DATA) $U(P) $U(M) VIDFS]
      set nE [llength $VFiles($Index)]
      for { set J 0 } { $J < $nE } { incr J } {
         set vN [lindex $VFiles($Index) $J]
         set vR [file join $vD $vN]

         if [file exists ${vR}V] {
            DBvidfToBinary ${vR}V
            if [file exists ${vR}I] { lappend fList ${vN}I }
         }
      }

      set dbE [file join $UDFPaths(1) I.asc]
      set dBdbf [file join $UDFPaths(1) $U(I).I.DBF]
      set dBndx [file join $UDFPaths(1) $U(I).I.NDX]
      DBremoveDups I $U(I) $fList

      for { set J 0 } { $J < $nE } { incr J } {
         set vN [lindex $VFiles($Index) $J]
         set vR [file join $vD $vN]
         set vT [file join $UDFPaths(2) $vN]

         if [file exists ${vR}I] { file rename -force ${vR}I ${vT}I }
      }

      DBgenEntries I $UDFPaths(2) $UDFPaths(2) $dbE $fList
      set ePos [DBdbfAppend $dBdbf $dbE]
      DBndxAppend $dBndx $dbE $ePos
      file delete -force $dbE
   }
}
