# THIS procedure reads in a VIDF 
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEreadVIDF { } {
   global env veANS ViDF SInfo SySCmDs

# IF we have already read in a VIDF make sure that we have saved it
#   before we clear the board.

   if [info exists ViDF(VERSION)] {
      if !$veANS(VIDFsaved) {
         VEgiveWarning 2
         if { $veANS(MsgV) == 1 } {
            VEsaveVIDF 0
         } elseif { $veANS(MsgV) == 2 } {
            return
         }
      }
   }

#  CLEAN up anything out there that may be hanging around from a previous
#    read

   VEcleanUp

   set veANS(VIDFsaved) 0

# MAKE sure that we have a full lineage specified.

   set PV [list P M E I V]
   for { set I 0 } { $I < 5 } { incr I } {
      set ChK [string trim $veANS(0,[lindex $PV $I])]
      if { [string length $ChK] == 0 } { VEgiveWarning 1 ; return }
   }

# CHECK to see if there is any input time range.  The time field from which
#    comparisions are built come from these.  Use default times if there
#    are no input times.

   set bYr  100;  set bDy 1 ; set bHr 0 ; set bMn 0 ; set bSc 0;
   set eYr 9000;  set eDy 1 ; set eHr 0 ; set eMn 0 ; set eSc 0;
   if ![string match YEAR $veANS(yRb)] { set bYr $veANS(yRb) }
   if ![string match DAY  $veANS(dYb)] { set bDy $veANS(dYb) }
   if ![string match HR   $veANS(hRb)] { set bHr $veANS(hRb) }
   if ![string match MIN  $veANS(mNb)] { set bMn $veANS(mNb) }
   if ![string match SEC  $veANS(sCb)] { set bSc $veANS(sCb) }
   if ![string match YEAR $veANS(yRe)] { set eYr $veANS(yRe) }
   if ![string match DAY  $veANS(dYe)] { set eDy $veANS(dYe) }
   if ![string match HR   $veANS(hRe)] { set eHr $veANS(hRe) }
   if ![string match MIN  $veANS(mNe)] { set eMn $veANS(mNe) }
   if ![string match SEC  $veANS(sCe)] { set eSc $veANS(sCe) }
   set bMsec [expr 3600000 * $bHr + 60000 * $bMn + 1000 * $bSc]
   set eMsec [expr 3600000 * $eHr + 60000 * $eMn + 1000 * $eSc]

   UDFInits

   if { [string compare BSRC $veANS(vSrc)] == 0 } {
      set Key [GetDataKey $veANS(0,P) $veANS(0,M) $veANS(0,E) \
                          $veANS(0,I) $veANS(0,V)]

      set List [DBgetEntries $Key $bYr $bDy $bMsec $eYr $eDy $eMsec I]
      set List [lsort -ascii -increasing -index 0 $List]
      set lLen [llength $List]
      if { $lLen == 0 } {
         set dHome $env(UDF_DATA)
         set diR [file join $dHome $veANS(0,P)]
         if ![file exists $diR] { file mkdir $diR }
         set diR [file join $diR $veANS(0,M)]
         if ![file exists $diR] { file mkdir $diR }
         set tDir [file join $diR Database]
         if ![file exists $tDir] { file mkdir $tDir }
         set vDir [file join $diR VIDFS]
         if ![file exists $vDir] { file mkdir $vDir } 
         set diR [file join $diR $veANS(0,E)]
         if ![file exists $diR] { file mkdir $diR }
         set diR [file join $diR $veANS(0,I)]
         if ![file exists $diR] { file mkdir $diR }
         VEblankVIDF
      } else { 
         if { $lLen > 1 } { 
            VEguiPick $List I
            set bYr [lindex $veANS(sTm) 0] ; set bDy [lindex $veANS(sTm) 1]
            set bHr [lindex $veANS(sTm) 2] ; set bMn [lindex $veANS(sTm) 3] 
            set bSc [lindex $veANS(sTm) 4]
            set eYr [lindex $veANS(sTm) 5] ; set eDy [lindex $veANS(sTm) 6]
            set eHr [lindex $veANS(sTm) 7] ; set eMn [lindex $veANS(sTm) 8] 
            set eSc [lindex $veANS(sTm) 9]
         }

         VEreadVidfI $Key $bYr $bDy $bHr $bMn $bSc $eYr $eDy $eHr $eMn $eSc 
      }
   } else {

# THIS is where the VIDFS should be found

      set dHome $env(UDF_DATA)
      set diR [file join $dHome $veANS(0,P)]
      set diR [file join $diR $veANS(0,M)]
      set vDir [file join $diR VIDFS]
      set vFiles [exec $SySCmDs(ls) $vDir] 
      set P [lsearch -glob -all $vFiles ${veANS(0,V)}*]
      set nP [llength $P]

      set vList ""
      for { set I 0 } { $I < $nP } { incr I } {
         set vName [lindex $vFiles [lindex $P $I]]
         if { [string index $vName end] == "V" } {
            lappend vList $vName
         }
      }

      set nP [llength $vList]

      if { $nP == 0 } { 
          VEblankVIDF
       } elseif { $nP == 1 } {
          set vName [lindex $vList 0]
       } else {
         VEguiPick $vList V
         set vName [lindex $veANS(sTm) 0]
      }
      set vName [file join $vDir $vName]
      if { [string compare SSRC $veANS(vSrc)] == 0 } {
         append vName .save
      } elseif { [string compare SSRC $veANS(vSrc)] == 0 } {
         append vName .orig
      }

      VEreadVidfV $vName
   }
}
