#  THIS procedure reads VIDF ASCII fields 

package provide VEDIT 1.0

proc VEprocTxTField { fd Field } {
   global VFields ViDF 

# GET the vidf field line and parse it

   gets $fd vLine
   set vOuT [DBvidfLineParse $vLine]

# IF this is an array field then we need to know how many lines of VIDF
#   entries it occupies.  Also if its an array then read the first line
#   of entries.  This initial read puts the array field at the same level
#   as a non-array field. 

   set LisT 1
   if { [lindex $vOuT 0] == "m" } {
      set v0 [TUdataNoOctal [lindex $vOuT 1]]
      set v1 [TUdataNoOctal [lindex $vOuT 2]]
      set nLines [expr int($v0 / $v1)]
      if { [expr $v0 % $v1] > 0 } { incr nLines }
      gets $fd vLine
      set vOuT [DBvidfLineParse $vLine]
   } else { set nLines 1 ; set LisT 0 }
  
# INITIALIZE the total bytes in this field to 0

   set tB 0

# LOOP over the lines in the field.  

   set J 0
   set ViDF($Field) ""
   while { $J < $nLines } {

# ALREADY read the data in and only need new data after the first line 
#   has been processed

      if { $J > 0 } {
         gets $fd vLine
         set vOuT [DBvidfLineParse $vLine]
      }

# THIS is where the different types of entries are processed.

      switch -exact -- [lindex $vOuT 0] {
         t  {   
            if $LisT {
               lappend ViDF($Field) [string trimright [lindex $vOuT 1]]
            } else { set ViDF($Field) [string trimright [lindex $vOuT 1]] }
         }
         T  {  
            set Entries [llength $vOuT]
            for { set I 1 } { $I < $Entries } { incr I } {
               set Line [lindex $vOuT $I]
               lappend ViDF($Field) $Line
            }
         }
         l -  
         s -
         b {
           set Entries [llength $vOuT]
           for { set I 1 } { $I < $Entries } { incr I } {
               set vO [TUdataNoOctal [lindex $vOuT $I] ]
               if { [string length $vO] == 0 } { set vO 0 }
               lappend ViDF($Field) $vO
            }
         }
         n  { }
      }
      incr J
   }
}
