# THIS procedure displays the VIDF status information
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEguiPAng { } {
   global env veANS ViDF VFields
                                                                                
   set W   .vePAng
   if { [winfo exists $W] == 0 } {
      toplevel $W

      set Wa $W.top
      set Wb $W.def
      set WbA $Wb.fill
      set WbB $Wb.blank
      set Wc $W.udf
      set WcA $Wc.lab
      set WcB $Wc.src
      set WcC $Wc.blank
      set Wd $W.blk1
      set WdA $Wd.fill
      set WdB $Wd.blank
      set We $W.blk2
      set WeA $We.fill
      set WeB $We.blank
      set Wf $W.blk3
      set WfA $Wf.fill
      set WfB $Wf.blank

      GUIFrame $Wa -1 pack|top||both|true
      GUIFrame $Wb  0 pack|top||both|true
      GUIFrame $WbA 0 pack|top|w
      GUIFrame $Wc  0 pack|top||both|true
      GUIFrame $WcA 0 pack|left|w
      GUIFrame $WcB 0 pack|left|w
      GUIFrame $Wd  0 pack|top||both|true
      GUIFrame $WdA 0 pack|top|w
      GUIFrame $We  0 pack|top||both|true
      GUIFrame $WeA 0 pack|top|w
      GUIFrame $Wf  0 pack|top||both|true
      GUIFrame $WfA 0 pack|top|w

      set iD [list PABXBYBZ PATBLS PAOPS]
      set MaxP -1
      set niD [llength $iD]
      for { set I 0 } { $I < $niD } { incr I } {
         set A [VEarrayFit ViDF([lindex $iD $I])]
         set aL [lindex $A 3]
         if { $aL > $MaxP } { set Parms $A ; set MaxP $aL }
      }

      set YNopts [list "NO|0" "YES|1"]
      set tL 16

      GUILabel $Wa.tit "$veANS(0,V) PITCH ANGLE DATA" w pack|left|w|x|true \
                  6 30 "" [list times 16 bold]
      GUIbuttonPush $Wa.close CLOSE pack|right "wm withdraw $W" 6

      GUILabel $WbA.ln "DEFINED" w grid|0|0|w 4 $tL
      if { $ViDF(PADEFINED) == 0 } { set LaB NO } else { set LaB YES }
      GUIbuttonToggle $WbA.df $LaB grid|0|1|w $YNopts \
          "GUIoptsToggle $WbA.df ViDF(PADEFINED) ALT " 6

      GUILabel $WcA.lsrc "SOURCE" w grid|0|0|nw 4 $tL
      set oP(0) N ; set oP(1) V ; set oP(5) NO
      GUudfPMEIV $WcB ViDF oP

      GUILabel $WdA.lsen "SENSORS" w grid|0|0|n 4 $tL
      GUIboxText $WdA.sen 60 2 grid|0|1 0 1 $veANS(bFonT)
      VEarrayOut $WdA.sen Parms PABXBYBZ

      GUIblankRow $WeA 0 .75
      GUILabel $WeA.lalg "ALGORITHM INFORMATION" w grid|1|0|w||2 4 -1 \
                     "" [list times 12 bold]
      GUIblankRow $WeA 2 .75
      GUILabel $WeA.lnap "NUM OF STEPS" w grid|3|0|w 4 $tL
      GUIboxEntry $WeA.nap grid|3|1|w 10 ViDF(PATBLS) "" $veANS(nFonT)

      GUILabel $WeA.ltbl "TABLES" w grid|4|0|n 4 $tL
      GUIboxText $WeA.tbl 60 3 grid|4|1 0 1 $veANS(bFonT)
      VEarrayOut $WeA.tbl Parms PATBLS

      GUILabel $WfA.lops "OPERATIONS" w grid|0|0|n 4 $tL
      GUIboxText $WfA.ops 60 3 grid|0|1 0 1 $veANS(bFonT)
      VEarrayOut $WfA.ops Parms PAOPS
   } else {
      if [string match withdrawn [wm state $W]] { wm deiconify $W }
   }
}
