# THIS procedure provides the GUI for the main page of VIDFEdit
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEguiMain { } {
   global env veANS
                                                                                
   TUreadUDFrc VEdit veANS
   set Wp .vePar

   if { [winfo exists $Wp] == 0 } {
      wm title . "VIDF Edit"

      set W   $Wp.veMain
      set Wa  $Wp.veOPTS
      set Wb  $Wp.veUSrc
      set Wc  $Wp.veUOps
      set Wd  $Wp.veTime

      GUIFrame $Wp  -1 grid|0|0|news
      GUIFrame $W   -1 grid|0|0|news||2
      GUIFrame $Wa  -1 grid|1|0|news||2
      GUIFrame $Wb  -1 grid|2|0|nw
      GUIFrame $Wc  -1 grid|2|1|news|
      GUIFrame $Wd  -1 grid|3|0|news||2

      GUILabel $W.lab "EVERYTHING VIDF" c \
            pack|left|center|x|true 6 30 "" [list times 16 bold]
      GUIbuttonPush $W.quit QUIT pack|right "exit"  6

      GUIbuttonPush $Wa.read READ pack|left  "VEreadVIDF" 6
      GUIbuttonPush $Wa.edit EDIT pack|left  "VEguiEdit"  6
      GUIbuttonPush $Wa.chk CHECK pack|left  "VEcheckVIDF" 6
      GUIbuttonPush $Wa.save SAVE pack|left  "VEsaveVIDF" 6
      GUIbuttonPush $Wa.orig ORIGINAL pack|left  "" 6
      GUIbuttonPush $Wa.rebuild REBUILD pack|left  "VErebuildVIDF" 6

      set oP(0) N ; set oP(1) V ; set oP(4) w ; set oP(5) NO
      GUudfPMEIV $Wb veANS oP

      GUILabel $Wd.t1 "BEG TIME" w grid|0|0 0 9
      GUILabel $Wd.t2 "END TIME" w grid|1|0 0 9

      set CoL 1
      set tE [list -- yR dY hR mN sC]
      set veANS(yRb) YEAR ; set veANS(dYb) DAY
      set veANS(hRb) HR ; set veANS(mNb) MIN ; set veANS(sCb) SEC
      set veANS(yRe) YEAR ; set veANS(dYe) DAY
      set veANS(hRe) HR ; set veANS(mNe) MIN ; set veANS(sCe) SEC
      for { set CoL 1 } { $CoL < 6 } { incr CoL } {
         set iD [lindex $tE $CoL]  
         set bG ${iD}b ; set eD ${iD}e 
         GUIboxEntry $Wd.$bG grid|0|$CoL 6 veANS($bG)
         GUIboxEntry $Wd.$eD grid|1|$CoL 6 veANS($eD)
         $Wd.$bG configure -fg #0000FF
         $Wd.$eD configure -fg #0000FF

         bind $Wd.$bG <Any-Key> {
            if [string match #0000FF [%W cget -fg]] {
               %W delete 0 end
               %W configure -fg #000000
            }
         }
         bind $Wd.$eD <Any-Key> {
            if [string match #0000FF [%W cget -fg]] {
               %W delete 0 end
               %W configure -fg #000000
            }
         }
      }
      GUIbuttonPush $Wd.reset RESET grid|0|$CoL|news|2 "VEresetTimes $Wd" 6

      set geom pack|top|e
      GUIbuttonRadio $Wc.asrc "ASCII Source" $geom veANS(aSrc) ASRC "" 0 13 
      GUIbuttonRadio $Wc.bsrc "Binary Source" $geom veANS(aSrc) BSRC "" 0 13 
      GUIbuttonRadio $Wc.ssrc "Save Source" $geom veANS(aSrc) SSRC "" 0 13
      GUIbuttonRadio $Wc.osrc "Orig Source" $geom veANS(aSrc) OSRC "" 0 13
      set geom pack|bottom|e
      GUIbuttonCheck $Wc.rebld "Rebuild w/Save" $geom veANS(ReBld) "" 0 13
      $Wc.asrc select
   }
}
