
# THIS procedure displays the VIDF general information
                                                                                
package provide VEDIT 1.0
                                                                                
proc VEguiGeneral { } {
   global env veANS ViDF VFields
                                                                                
   set W   .veGeneral
   if { [winfo exists $W] == 0 } {
      toplevel $W

      set Wa $W.top
      set Wb $W.info

      set YNopts [list NO|0 Yes|1] 
      set SMPopts [list "Partial Array|0" "Full Array|1" Scalar|2 Matrix|3] 
      set SMDopts [list "Down Column|0" "Across Row|4"]
      set SMopts  [list "Sequential-Sequentual|0" "Sequential-Parallel|1" \
                        "Parallel-Sequentual|2" "Parallel-Parallel|3" ]

      GUIFrame $Wa -1 pack|top||both|true
      GUIFrame $Wb -1 pack|top||both|true

      GUILabel $Wa.tit "$veANS(0,V) GENERAL FIELDS" w pack|left|w|x|true \
                  6 30 "" [list times 16 bold]
      GUIbuttonPush $Wa.close CLOSE pack|right "wm withdraw $W" 6

      set Row 0
      GUILabel $Wb.1a "NUMBER OF TABLES" w grid|$Row|0|e
      GUIboxEntry $Wb.da grid|$Row|1|w 10 ViDF(NUMTBLS) "" $veANS(nFonT)
      incr Row

      GUILabel $Wb.lb "NUMBER OF CONSTANTS" w grid|$Row|0|e
      GUIboxEntry $Wb.db grid|$Row|1|w 10 ViDF(NUMCONSTS) "" $veANS(nFonT)
      incr Row
  
      GUILabel $Wb.lc "DATA RECORD LENGTH" w grid|$Row|0|e
      GUIboxEntry $Wb.dc grid|$Row|1|w 10 ViDF(DATALEN) "" $veANS(nFonT)
      incr Row
  
      GUILabel $Wb.ld "MAXIMUM SENSOR SET NUMBER" w grid|$Row|0|e
      GUIboxEntry $Wb.dd grid|$Row|1|w 10 ViDF(MAXNSS) "" $veANS(nFonT)
      incr Row
  
      GUILabel $Wb.le "SENSOR TYPE" w grid|$Row|0|e
      set Label [lindex [split [lindex $SMPopts $ViDF(SMPID)] "|"] 0]
      GUIbuttonMenu $Wb.de "$Label" grid|$Row|1|news| $SMPopts \
          "GUIoptsProcess .veGeneral.info.de veANS(SMPID) ALT " 6
      incr Row
  
      GUILabel $Wb.lf "TIME DIRECTION" w grid|$Row|0|e
      if { $ViDF(SENMODE) < 4 } {
         set ViDF(TDIR) 0 
	 set Label "Down Column"
      } else {
         set ViDF(TDIR) 4 
	 set Label "Across Row"
      }
      GUIbuttonToggle $Wb.df "$Label" grid|$Row|1|news| $SMDopts \
          "GUIoptsToggle .veGeneral.info.df veANS(TDIR) ALT " 6
      incr Row

      GUILabel $Wb.lg "TIME FLOW (ROW/COL)" w grid|$Row|0|e
      set ViDF(TFLOW) [expr $ViDF(SENMODE) % 4]
      set Label [lindex [split [lindex $SMopts $ViDF(TFLOW)] "|"] 0]
      GUIbuttonMenu $Wb.dg "$Label" grid|$Row|1|news| $SMopts \
          "GUIoptsProcess .veGeneral.info.dg veANS(TDIR) ALT " 6
      incr Row

      GUILabel $Wb.lh "FILL DEFINED" w grid|$Row|0|e
      set Label [lindex [split [lindex $YNopts $ViDF(FILLFLAG)] "|"] 0]
      GUIbuttonToggle $Wb.dh "$Label" grid|$Row|1|news| $YNopts \
          "GUIoptsToggle .veGeneral.info.dh veANS(FILLFLAG) ALT " 6
      incr Row
  
      GUILabel $Wb.li "FILL VALUE" c grid|$Row|0|e
      GUIboxEntry $Wb.di grid|$Row|1|w 10 ViDF(FILL) "" $veANS(nFonT)
   } else {
      if [string match withdrawn [wm state $W]] { wm deiconify $W }
   }
}
