# THIS procedure us used to see if a text box size can be shortened.
#
# GiD:    the GUI Menu Page  iD  
# Parms:  the computed line parameters for the page
 
package provide VEDIT 1.0
                                                                                
proc VEboxSize { GiD Parms eN ParmsEx } {
   global env veANS ViDF
  
   upvar $Parms Ps
   upvar $ParmsEx PsE

   set Ps   ""
   set PsE  ""
   set mL   ""
   set IgN  -1
   
   switch -exact -- $GiD {
      COMMENTS {
         set ViD [list COMMENTS.t]
         set eL  [list 5 ]
         set cL [expr $veANS(MaxL) - 2]
      }
      QUALITY {
         set ViD [list QUALNAME.t]
         set eL  [list 5 ]
         set cL [expr $veANS(MaxL) - 3]
      }
      STATUS {
         set ViD [list STATES.n STATUSNAME.t]
         set eL [list 2 5]
         set cL [expr $veANS(MaxL) - 3]
      }
      SENSOR {
         set ViD [list SENNAME.t TDWLEN.n DATATYPE.n TIMEOFF.n SENSTATUS.n]
         set eL  [list 5 3 3 3 3]
         set cL [expr $veANS(MaxL) - 5]
      }
      ANCILLARY {
         set ViD [list CALNAMES.t CALWLEN.n CALUSE.n CALTARGET.n]
         set eL  [list 5 3 3 3]
         set cL [expr $veANS(MaxL) - 3]
      }
      TABLES {
         set TiD [ list TBLDESC.t CRITSTATUS.n CRITOFF.n CRITACTION.n \
                        TBLFMT.n TBLOFF.n TBLSCA.n TBL.n]
         set niD [expr [llength $TiD] - 1]

         set ViD ""
         if { $ViDF(TBLTYPE,$eN) == 1 } { set IgN $niD }

         for { set I 0 } { $I <= $niD } { incr I } {
             set T [split [lindex $TiD $I] "."] 
             lappend ViD [lindex $T 0],$eN.[lindex $T 1]
         }
         
         set eL  [list 3 2 2 3 2 2 3 3]
         set mL  [list 5 3 3 4 3 3 3 5]
         set cL [expr $veANS(MaxL) - 8]
      }
      CONSTANTS {
         set TiD [ list CONSTDESC.t CONSTSCA.n CONST.n]

         set niD [expr [llength $TiD] - 1]
         for { set I 0 } { $I <= $niD } { incr I } {
             set T [split [lindex $TiD $I] "."] 
             lappend ViD [lindex $T 0],$eN.[lindex $T 1]
         }
         
         set eL  [list 3 2 2]
         set mL  [list 5 3 3]
         set cL [expr $veANS(MaxL) - 3]
      }
   }

   if { [string length $mL] == 0 } { set mL $eL }

   set MaxP -1
   set niD [expr [llength $ViD] - 1]
   for { set I 0 } { $I <= $niD } { incr I } {
      if { $I == $IgN } { 
         set PsE [VEarrayFit ViDF($iD)]
      } else {
         set T [split [lindex $ViD $I] "."] 
         set iD [lindex $T 0]
         if { [lindex $T 1] == "n" } {
            set A [VEarrayFit ViDF($iD)]
            set aL [lindex $A 3]
            if { $aL > $MaxP } { set Ps $A ; set MaxP $aL }
         }
      }
   }

   for { set I 0 } { $I <= $niD } { incr I } {
      set T [split [lindex $ViD $I] "."] 
      set iD [lindex $T 0]
      if [info exists ViDF($iD)] { 
         set CnT [llength $ViDF($iD)]
         if { [lindex $T 1] == "t" } {
            set nE($I) $CnT
         } else {
            if { $I != $IgN } { set mP $MaxP } else { set mP [lindex $PsE 3] }
            set P [expr int(80/($mP + 2))]
            set nE($I) [expr int($CnT / $P)]
            if { [expr $CnT % $P] > 0 } { incr nE($I) }
         }
      } else { set nE($I) 0 }
   }

   set TotL 0
   for { set I 0 } { $I <= $niD } { incr I } {
      set nEe($I) [expr $nE($I) + [lindex $eL $I]]
      set TotL [expr $TotL + $nEe($I)]
   }

   set BoxL ""
   if { $TotL <= $cL } {
      for { set I 0 } { $I <= $niD } { incr I } { lappend BoxL $nEe($I) }
   } else {
      set Used 0
      set Need 0
      for { set I 0 } { $I <= $niD } { incr I } { 
         set OK($I) 1
         set eGoT [lindex $eL $I]
         set mGoT [lindex $mL $I]
         if { $nE($I) == 0 } {
            set GoT $eGoT
         } elseif { $nE($I) <= $mGoT } { 
            set GoT $mGoT
         } elseif { $nE($I) > $mGoT } { 
            set Need [expr $Need + $nE($I)] 
            set OK($I) 0  
            set GoT 0
         }

         set Used [expr $Used + $GoT]
         lappend BoxL $GoT
      }

      set Left [expr $cL - $Used]
      for { set I 0 } { $I <= $niD } { incr I } { 
         if !$OK($I) {
            if { $I < $niD } { 
               set GoT  [expr int($Left * $nE($I) / double($Need))]
               if { $GoT < [lindex $mL $I] } { set GoT [lindex $mL $I] }
               set Left [expr $Left - $GoT]
            } else { set GoT $Left }
            set BoxL [lreplace $BoxL $I $I $GoT] 
         }
      }
   }
             
   return $BoxL
}
