/*
** udf.h  --  header stuff for UDF package
**
*/

#ifndef	__UDF_DLM_H
#define	__UDF_DLM_H 1

ByTe_1    Ext[3];
u_ByTe_2   Version;

struct fh_cache fh_list[MAX_OPEN];

IDL_STRUCT_TAG_DEF s_tags_udf_time[] = {
  { "YEAR",     0, (void*)IDL_TYP_INT  },       /* 16 bits, up to 32767 */
  { "DOY",      0, (void*)IDL_TYP_UINT },       /* Day of year, 1-366   */
  { "HOUR",     0, (void*)IDL_TYP_BYTE },       /* Hour, 0-23           */
  { "MIN",      0, (void*)IDL_TYP_BYTE },       /* Minutes, 0-59        */
  { "SEC",      0, (void*)IDL_TYP_BYTE },       /* Seconds, 0-59 (-60?) */
  { "MSEC",     0, (void*)IDL_TYP_UINT },       /* milliseconds, 0-999  */
  { "DP",       0, (void*)IDL_TYP_DOUBLE },     /* whatever you like    */
  { 0 }
};

IDL_STRUCT_TAG_DEF s_tags_udf_times[] = {
  { "BTIME",   0, 0 /* s_udf_time */ },
  { "ETIME",   0, 0 /* s_udf_time */ },
  { 0 }
};

IDL_STRUCT_TAG_DEF s_tags_udf_misc[] = {
  { "FILESIZE",  0, (void*)IDL_TYP_LONG },       /* data file size in bytes */
  { "RECSISE",   0, (void*)IDL_TYP_LONG },       /* record size in bytes    */
  { "NUMRECS",   0, (void*)IDL_TYP_LONG },       /* number of recs in file  */
  { 0 }
};

void     *UDF = 0;                    /* Pointer to "IDF" data structure   */
void     *s_udf_time;
void     *s_udf_times;
void     *s_udf_misc;
void     *TmpName;
void     *TmpType;
void     *TmpDim;
void     *TaGs; 
void     *TmpSpace = 0;
ByTe_4   TmpBytes = 0;

#endif	/* __UDF_DLM_H */
