#include <stdlib.h>
#include <stdio.h>
#include "util_str.h"
#include "ret_codes.h"
#include "gen_defs.h"
#include "libbase_udf.h"

/*****************************************************************************
 *                                                                           *
 *                             FreeUpOne  SUBROUTINE                         *
 *                                                                           *
 *  DESCRIPTION                                                              *
 *    This routine closes the files opened in a UDF_OPEN, frees up most of   *
 *    the memory associated with the open, and resets the those flags used   *
 *    in a new open of this UDF definition.                                  *
 *                                                                           *
 ****************************************************************************/

ByTe_2 FreeUpOne (u_ByTe_4 KeY, ByTe_1 *ExT, u_ByTe_2 VeR) 
{
   extern struct general_info ginfo;
   ByTe_2 rV;

   /*************************************************************************/
   /*  Check to see if the combination being freed has been processed       */
   /*  before.  Since ir_locate_ex() is called by more than one routine,    */
   /*  return an error code indicative of which calling routine resulted in */
   /*  the error. Passing a 0 for the last parameter, the only possible     */
   /*  error is that the requested combination was not found in the         */
   /*  processed combos.                                                    */
   /*************************************************************************/
  
   if (!ginfo.called_locate) {
      rV = ir_locate_ex (KeY, ExT, VeR, 0);
      if (rV != ALL_OKAY) { return (RESET_NOT_FOUND); }
    }

   /*************************************************************************/
   /*  Close the header, data, and VIDF file currently opened and reset the */
   /*  file descriptors to indicate that no file has been opened.           */
   /*************************************************************************/

   ir_free_ex_structure (ginfo.expt);
   ginfo.expt->data_key = 0;
   return (ALL_OKAY);
}
