#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void ConvMode (struct fh_cache *fh, ByTe_1 *Base)
{
   extern ByTe_1 Ext[];
   extern u_ByTe_2 Version;
   extern void *UDF;

   struct Pidf        *P;
   struct PidfUnit    *Pu;

   ByTe_2 *s1, *s2;
   ByTe_2 I, mU, Len;
   ByTe_2 rV;
   ByTe_1 mN;
   ByTe_1 DataField;

   ByTe_1 *trac;

   P = (struct Pidf *)fh->PIDF;
   Pu = (struct PidfUnit *)P->Units;

   trac = Base + fh->Begs[_MODE_];
   DataField =  (fh->sType == IDL_TYP_DOUBLE) ? DMODE : MODE;
   Len =  (fh->sType == IDL_TYP_DOUBLE) ? sizeof(ReaL_8) : sizeof(ReaL_4);
   s1 = fh->Units + fh->TotVSen + fh->TotAnc;
   s2 = fh->Order + fh->TotVSen + fh->TotAnc;
   for (I = 0; I < fh->TotMode; ++I) {
       mU = *s1++;
       mN = *s2++;
       rV = convert_to_units(fh->Key, Ext, Version, UDF, DataField,
                             mN, (ByTe_1)Pu[mU].NTbls, Pu[mU].Tbls, 
                             Pu[mU].Ops, (ReaL_4*)trac, 0, 0);
       if (rV != ALL_OKAY)
           udf_barf("convert_to_units", rV);
       trac += Len;
   }
}
