/*
** udf.h  --  header stuff for UDF package
**
*/

#ifndef	__UDF_DLM_STR_H
#define	__UDF_DLM_STR_H 1

/*
** for the filehandle cache we keep
*/

struct fh_cache {
  u_ByTe_4    Key;		/* Key; identifies proj/miss/../vinst	*/
  ByTe_1      BaseName[80];	/* Base Name of V.Inst (for struct def)	*/
  ByTe_2      LastRead;         /* Status of the last read_drec call    */
  ByTe_2      is_open;		/* UDF doesn't like multiple opens	*/
  ByTe_2      Ey;               /* requested ending year                */
  ByTe_2      Ed;               /* requested ending day                 */
  ByTe_4      Ems;              /* requested ending millisecond         */
  ByTe_2      tV;               /* total opt values recovered           */
  ByTe_2      TotVSen;		/* Total number of VIDF sensor defs     */
  ByTe_2      TotAnc;		/* Total number of ANC definitions      */
  ByTe_2      TotMode;	        /* Total number of modes definitions    */
  ByTe_2      TotIndex;         /* Total array index definitions        */
  size_t      dSize;            /* total size to malloc() for data      */
  ByTe_4      vNum;             /* number of vidf memory blocks         */
  ByTe_4      MyChoice;         /* dummy variable                       */
  ByTe_4      sType;            /* IDL variable type used by data       */
  ByTe_2      *Order;	        /* What order to read sensors           */
  ByTe_2      *Units;	        /* What "units" to "convert" to		*/
  ByTe_1      *Set;	        /* Anc Data set numbers                 */
  ByTe_1      *Loc;	        /* Where the Anc definition is in PIDF  */
  ByTe_1      *uNDef;	        /* Units: 0, 1of1; 1, 1of2; 2 2of2      */
  ByTe_1      *Dim;	        /* Dimension of Anc (Scalar or Array)   */
  ByTe_4      NCols;            /* Number of columns in each "matrix"   */
  ByTe_4      TotSeN;           /* total structure sensor elements      */
  ByTe_2      nT;               /* Number of tables in VIDF             */
  ByTe_2      nC;               /* Number of constants in VIDF          */
  void        *PIDF;		/* PIDF structure definition		*/
  void        *dA;              /* structure data area                  */
  void        **vA;             /* structure vidf area                  */
  void        *pInfo;           /* unit Information from menu           */
  void        *sdef;		/* IDL sensor structure definition	*/
  void        **mV;		/* VIDF mallocs                 	*/
  struct {
    UCHAR  sformat;
    UCHAR  azimuth;
    UCHAR  theta;
    UCHAR  indices;
    UCHAR  dformat;
    UCHAR  baseunit;
    UCHAR  gotkeys;
    UCHAR  Tmp;
  } flags;
};

struct udf_time {                       /* This must be identical to */
  short          year;                  /* the IDL structure below   */
  unsigned short doy;
  unsigned char  hour;
  unsigned char  min;
  unsigned char  sec;
  unsigned short msec;
  double         dp;
};

struct udf_times {
  struct udf_time btime;
  struct udf_time etime;
};

struct udf_misc {
   IDL_LONG FLen;
   IDL_LONG RLen;
   IDL_LONG NRecs;
};

struct udf_vidfbody {
   IDL_LONG  bYr;
   IDL_LONG  bDy;
   IDL_LONG  bMs;
   IDL_LONG  bUs;
   IDL_LONG  eYr;
   IDL_LONG  eDy;
   IDL_LONG  eMs;
   IDL_LONG  eUs;
};

struct basic_struct {
   char   data[8];
};

#endif	/* __UDF_DLM_STR_H */
