#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/*****************\
|*  UDF_JUMPTIME  *|  Jump to a random time in the file
\*****************/

PROCEDURE UDF_JUMPTIME(int Argc, IDL_VPTR Argv[], char *Argk)
{
   extern struct fh_cache fh_list[];
   extern ByTe_1 Ext[];
   extern u_ByTe_2 Version;
   extern void *UDF;

   struct Pidf   *P;
   ByTe_4    HH, MM, SS;
   ByTe_2    rV, YSgn;
   ByTe_4    FhNum;
   ByTe_2    By, Bd, Ey, Ed, *s1;
   ByTe_4    Bs, Bns, Es, Ens;

   struct fh_cache *fh;

  /************************************************************************/
  /*  Calling Arguments:                                                  */
  /*                                                                      */
  /*  1.  FhNum                                                           */
  /*  2.  Beginning Year, Day, Hh, Mm, Ss  (either as scalars or array)   */
  /*  3.  Optional Value: Indicates file_pos or FilePosRec for position   */
  /*     0 - use file_pos (to nearest time)                               */
  /*     1 - use filePosRec (to nearest data record)                      */
  /************************************************************************/

   if (Argc < 2) 
      IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP,
        "Usage\n: UDF_JUMPTIME, fh, [Y, D, H, M, S], {PosFmt}\n UDF_JUMPTIME, fh, Y, D, H, M, S, {PosFmt}");

  /************************************************************************/
  /* Set up default blocking - may be overwritten by input                */
  /************************************************************************/

   FhNum = Argv[0]->value.i;
   fh = &fh_list[FhNum];
   P = (struct Pidf *)fh->PIDF;
   YSgn  = (P->Pf.Blocking == 0) ? 1 : -1;

  /************************************************************************/
  /* Process inputs                                                       */
  /************************************************************************/

   if (Argc == 2 || Argc ==3) {
      if (Argv[1]->flags & IDL_V_NOT_SCALAR) {
         if (Argv[1]->value.arr->dim[0] < 5)
            idl_barf("UDF_JUMPTIME: Time Must Be [Yr, Dy, Hr, Mn, Ss]");

         s1 = (ByTe_2 *)Argv[1]->value.arr->data;
         By  = *s1++;
         Bd  = *s1++;
         HH  = *s1++;
         MM  = *s1++;
         SS  = *s1++;
         Bs =  3600 * HH + 60 * MM + SS;
         Bns = 0;
         if (Argc == 3)
            YSgn  = (Argv[2]->value.ul == 0) ? 1 : -1;
      }
   } else {
      if (Argc < 6 )
         IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP,
           "Usage: fH = UDF_JUMPTIME( fh, Yr, Dy, HH, MM, SS, {Optional}Fmt)");

      By  = Argv[1]->value.ul;
      Bd  = Argv[2]->value.ul;
      HH  = Argv[3]->value.ul;
      MM  = Argv[4]->value.ul;
      SS  = Argv[5]->value.ul;
      Bs =  3600 * HH + 60 * MM + SS;
      Bns = 0;
      if (Argc == 7)
         YSgn  = (Argv[6]->value.ul == 0) ? 1 : -1;
   }

   Ey = YSgn * fh->Ey;
   Ed = fh->Ed;
   Es = fh->Ems / 1000;
   Ens = 0;

   rV = ToThisTime(fh->Key, Ext, Version, UDF, By, Bd, Bs, Bns,
		    Ey, Ed, Es, Ens);

  if (rV == TIME_NOT_FOUND)	                  /* Only likely on reopen() */
     idl_barf("UDF_JUMPTIME: No Data For This Time");
  if (rV != ALL_OKAY)
     udf_barf("ToThisTime", rV);
}
