#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"
#include "udfdlm_str.h"

void TimeFill(struct fh_cache *fh, ByTe_4 Item)
{
   extern void *UDF;

   IDL_VPTR *V;

   struct idf_data *U;
   struct udf_time *T;
   ByTe_4 Yr, Dy, Ms;
   ByTe_1 *mB; 
   int eN;

   U = (struct idf_data *)UDF; 
   V = 0;

   mB = (ByTe_1 *)fh->dA;

   if (Item == _BTIME_) {
      Yr = U->byear;
      Dy = U->bday;
      Ms = U->bmilli;
      eN = 0;
   } else {
      Yr = U->eyear;
      Dy = U->eday;
      Ms = U->emilli;
      eN = 1;
   }

   T = (struct udf_time *)(mB + IDL_StructTagInfoByIndex(fh->sdef, eN, 0, V));

  /*
  ** "dp" field is for the user's convenience.  It can be anything,
  ** but we initialize it to a day number based on Jan 1 2000, because
  ** that's what Ed likes.
  */

  T->dp = 0;
  T->dp    = floor((Yr - 2000) * 365.25)
                 + Dy - (Yr % 4 == 0)
                 + ((double)Ms / ((double)SECONDS_PER_DAY*1000.0));

  T->year  = Yr;
  T->doy   = Dy;

  T->msec  = (unsigned short)(Ms % 1000);  Ms /= 1000;
  T->sec   = (unsigned char) (Ms % 60);    Ms /= 60;
  T->min   = (unsigned char) (Ms % 60);    Ms /= 60;
  T->hour  = (unsigned char) Ms;
}
