#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "Util1Ansi.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void StoreData(void *vD, ByTe_1 *mB, ByTe_1 *iB, ByTe_2 iF, ByTe_2 sF, 
                           int eN, ByTe_4 aL, ByTe_4 eL )   
{
   IDL_LONG    *l1;
   IDL_STRING  *sT;
   IDL_VPTR    *vP;

   ReaL_8      *d1, *d2;
   ReaL_4      *f1, *f2;
   ByTe_4      I, oFF;
   ByTe_4      *l2;
   ByTe_2      *s2;
   ByTe_1      *c2;

   vP = 0;

  /************************************************************************/
  /* Byte offset to start of structure element                            */
  /************************************************************************/

  oFF = IDL_StructTagInfoByIndex(vD, eN, 0, vP);

  /************************************************************************/
  /*  Storeage Formats:                                                   */
  /*     0: 79 byte strings                                               */
  /*     1: 20 byte strings                                               */
  /*     2: IDL_LONG                                                      */
  /*     3: float                                                         */
  /*     4: double                                                        */
  /*  Input Formats:                                                      */
  /*     0: ByTe_1                                                        */
  /*     1: ByTe_2                                                        */
  /*     2: ByTe_4                                                        */
  /*     3: ReaL_4                                                        */
  /*     4: ReaL_8                                                        */
  /************************************************************************/

   switch (sF) {
      case 0:
         sT = (IDL_STRING *)(mB + oFF +  eL * sizeof(IDL_STRING));
	 for (I = 0; I < aL; ++I, iB += 80, ++sT) {
            sT->slen = 79;
            sT->stype = 0;
            sT->s = iB;
         }
      break;
      case 1:
         sT = (IDL_STRING *)(mB + oFF +  eL * sizeof(IDL_STRING));
	 for (I = 0; I < aL; ++I, iB += 21, ++sT) {
            sT->slen = 20;
            sT->stype = 0;
            sT->s = iB;
         }
      break;
      case 2:
         l1 = (IDL_LONG *)(mB + oFF +  eL * sizeof(IDL_LONG));
	 switch (iF) {
	    case 0:
	       c2 = iB;
	       for (I = 0; I < aL; ++I ) { *l1++ = *c2++; }
	    break;
	    case 1:
	       s2 = (ByTe_2 *)iB;
	       for (I = 0; I < aL; ++I ) { *l1++ = *s2++; }
	    break;
	    case 2:
	       l2 = (ByTe_4 *)iB;
	       for (I = 0; I < aL; ++I ) { *l1++ = *l2++; }
	    break;
	 }
      break;
      case 3:
         f1 = (ReaL_4 *)(mB + oFF +  eL * sizeof(ReaL_4));
	 switch (iF) {
	    case 0:
	       c2 = iB;
	       for (I = 0; I < aL; ++I ) { *f1++ = *c2++; }
	    break;
	    case 1:
	       s2 = (ByTe_2 *)iB;
	       for (I = 0; I < aL; ++I ) { *f1++ = *s2++; }
	    break;
	    case 2:
	       l2 = (ByTe_4 *)iB;
	       for (I = 0; I < aL; ++I ) { *f1++ = *l2++; }
	    break;
	    case 3:
	       f2 = (ReaL_4 *)iB;
	       for (I = 0; I < aL; ++I ) { *f1++ = *f2++; }
	    break;
	 }
      break;
      case 4:
         d1 = (ReaL_8 *)(mB + oFF +  eL * sizeof(ReaL_8));
	 switch (iF) {
	    case 0:
	       c2 = iB;
	       for (I = 0; I < aL; ++I ) { *d1++ = *c2++; }
	    break;
	    case 1:
	       s2 = (ByTe_2 *)iB;
	       for (I = 0; I < aL; ++I ) { *d1++ = *s2++; }
	    break;
	    case 2:
	       l2 = (ByTe_4 *)iB;
	       for (I = 0; I < aL; ++I ) { *d1++ = *l2++; }
	    break;
	    case 3:
	       f2 = (ReaL_4 *)iB;
	       for (I = 0; I < aL; ++I ) { *d1++ = *f2++; }
	    break;
	    case 4:
	       d2 = (ReaL_8 *)iB;
	       for (I = 0; I < aL; ++I ) { *d1++ = *d2++; }
	    break;
	 }
      break;
   }
}
