#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"
#include "udfdlm_str.h"

ByTe_4 SetUpTag(ByTe_1 *TagName, ByTe_4 Type, ByTe_4 *Dim, ByTe_4 nTag,
                                                           ByTe_4 *MaxTag)
{
    extern void *TmpType;
    extern void *TmpName;
    extern void *TmpDim;

    IDL_MEMINT *l1;
    ByTe_4 B, Tot, D1, D2, D3;
    ByTe_2 *s1;
    ByTe_1 *c1;

    if (*MaxTag < nTag) {
       B = (nTag + 1) * MAX_TAG_LEN;
       if ((TmpName = realloc(TmpName,B)) == NULL)
           idl_barf("SetUpTags: realloc(TmpName)");

       B = (nTag + 1) * (4 * sizeof(IDL_MEMINT));
       if ((TmpDim = realloc(TmpDim,B)) == NULL)
           idl_barf("SetUpTags: realloc(TmpDim)");

       B = (nTag + 1) * sizeof(ByTe_2);
       if ((TmpType = realloc(TmpType,B)) == NULL)
           idl_barf("SetUpTags: realloc(TmpType)");

       *MaxTag = nTag;
    }

    c1 = (ByTe_1 *)TmpName + MAX_TAG_LEN * nTag;
    s1 = (ByTe_2 *)TmpType + nTag;
    l1 = (IDL_MEMINT *)TmpDim + 4 * nTag;
    D1 = Dim[0];
    D2 = Dim[1];
    D3 = Dim[2];

    strcpy (c1, TagName);

    switch (Type)
    {
       case UDF_TIME: 
         *s1 = 0;
         Tot = sizeof(struct udf_time);
       break;
       case IDL_TYP_BYTE: 
         *s1 = 1;
         Tot = sizeof (UCHAR);
       break;
       case IDL_TYP_LONG: 
         *s1 = 2;
         Tot = sizeof (IDL_LONG);
       break;
       case IDL_TYP_FLOAT: 
         *s1 = 3;
         Tot = sizeof (float);
       break;
       case IDL_TYP_DOUBLE: 
         *s1 = 4;
         Tot = sizeof (double);
       break;
       case IDL_TYP_STRING: 
         *s1 = 5;
         Tot = sizeof(IDL_STRING);
       break;
       case IDL_TYP_ULONG: 
         *s1 = 6;
         Tot = sizeof (IDL_ULONG);
       break;
       case IDL_TYP_INT: 
         *s1 = 7;
         Tot = sizeof (IDL_INT);
       break;
       case IDL_TYP_UINT: 
         *s1 = 8;
         Tot = sizeof (IDL_UINT);
       break;
    }

    l1[0] = (D1 <= 0) ? 0 : (D2 == 0) ? 1 : (D3 == 0) ? 2 : 3;
    l1[1] = D1;
    l1[2] = D2;
    l1[3] = D3;

    if (D1 == 0) D1 = 1;
    if (D2 == 0) D2 = 1;
    if (D3 == 0) D3 = 1;

    Tot *= D1 * D2 * D3;

    return (Tot);
}
