#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

u_ByTe_4 ReadOpts (ByTe_1 *OptFile)
{
    extern struct fh_cache fh_list[];
   
    struct fh_cache *fh;

    FILE     *fo;
    u_ByTe_4 Key;
    size_t   B;
    ByTe_4   Items, *l1, L;
    ByTe_2   rV, *s1, *s2;
    ByTe_1   names[250];
    ByTe_1   *P, *M, *E, *I, *V, *c1;

    if ((fo = fopen (OptFile, "r")) == NULL) {
       idl_barf ("Unit Definition File %s Not Found", OptFile);
       return (Key);
    }

    P = names;
    M = &names[50];
    E = &names[100];
    I = &names[150];
    V = &names[200];
    fscanf (fo, "%s %s %s %s %s", P, M, E, I, V);
    rV = get_data_key(P, M, E, I, V, &Key);
    if (rV != ALL_OKAY)
       udf_barf(NULL, rV);

    fh = &fh_list[FindFh(Key)];

    fscanf (fo, "%d", &Items);
    L = 0;

    if (L++ < Items)
       fscanf (fo, "%d", &B);

    if (L++ < Items)
    {
       fscanf (fo, "%d", &B);
       fh->flags.sformat = B;
    } else { fh->flags.sformat = 0; }

    if (L++ < Items)
    {
       fscanf (fo, "%d", &B);
       fh->flags.dformat = B;
    } else { fh->flags.dformat = 0; }

    if (L++ < Items)
    {
       fscanf (fo, "%d", &B);
       fh->flags.azimuth = B;
    } else { fh->flags.azimuth = 0; }

    if (L++ < Items)
    {
       fscanf (fo, "%d", &B);
       fh->flags.theta = B;
    } else { fh->flags.theta = 0; }

    if (L++ < Items)
    {
       fscanf (fo, "%d", &B);
       fh->flags.indices = B;
    } else { fh->flags.indices = 0; }
  
    fscanf (fo, "%hd", &fh->tV);
    B = fh->tV * (sizeof(ByTe_4) + 3 * sizeof(ByTe_2));
    if ((fh->pInfo = malloc(B)) == NULL)
        idl_barf("ReadOpts: malloc(fh->pInfo)");
    B = sizeof(ByTe_4);
    l1 = (ByTe_4 *)fh->pInfo;
    s1 = (ByTe_2 *)((ByTe_1 *)fh->pInfo + fh->tV * B);
    B += sizeof(ByTe_2);
    s2 = (ByTe_2 *)((ByTe_1 *)fh->pInfo + fh->tV * B);
    B += sizeof(ByTe_2);
    c1 = (ByTe_1 *)((ByTe_1 *)fh->pInfo + fh->tV * B);

    for (L = 0; L < fh->tV; ++L)
       fscanf (fo, "%d %c %hd %hd", l1++, c1++, s1++, s2++);

    fclose (fo);
    return (Key);
}
