#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "util_str.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"
#include "udfdlm_str.h"

void *MkDataStruc( struct fh_cache *fh)
{
   extern void     *TmpDim;
   extern void     *TmpName;
   extern void     *TmpSpace;
   extern void     *TmpType;
   extern void     *TaGs;
   extern ByTe_4   TmpBytes;

   extern struct general_info ginfo;
   extern u_ByTe_2 Version;
   extern ByTe_1 Ext[];


/*
   extern int      ALIGN_MASK;
*/

   struct Pidf         *P;
   struct PidfSensor   *Px;
   struct PidfMode     *Pm;
   struct PidfAnc      *Pa;
   struct experiment_info *ex;

   ByTe_4              MaxTag;
   ByTe_2              *s1, Rv;
   int                 nTag = 0;
   void                *dS;

   ByTe_4              N, lS;
   ByTe_4              TotItems;
   ByTe_4              Dim[3];
   size_t              B;

   ByTe_1              Name[1024];
   ByTe_1              Tname[1024];
   ByTe_1              *c1, *c2;

  /******************************************************************/
  /*  If the structure definition is not NULL then one exists.      */
  /*  This is probably an OPEN without a CLOSE.  Just return the    */
  /*  the structure definition we have and hope for the best        */
  /******************************************************************/

   if (fh->sdef != NULL ) { return fh->sdef; }

  /******************************************************************/
  /* Set pointers to the PIDF information structures                */
  /******************************************************************/

   P =  (struct Pidf *)fh->PIDF;
   Px = (struct PidfSensor *)P->Sensors;
   Pm = (struct PidfMode *)P->Modes;
   Pa = (struct PidfAnc *)P->Ancil;

  /******************************************************************/
  /* Set pointer to the esperiment info structure                   */
  /******************************************************************/

   Rv = ir_locate_ex (fh->Key, Ext, Version, 0);
   if (Rv == ALL_OKAY) {
      ex = ginfo.expt;
   } else { udf_barf("LOCATE_EX", Rv); }

  /******************************************************************/
  /* This is how to accumulate and output the sensor data           */      
  /******************************************************************/

   fh->sType = (fh->flags.dformat == 0) ? IDL_TYP_FLOAT : IDL_TYP_DOUBLE;

  /******************************************************************/
  /* First Cut at total items returned                              */
  /******************************************************************/

   fh->TotVSen = P->Ps.NSensors + CntExtra (fh, 'S');
   fh->TotAnc = P->Ps.NAncils + CntExtra (fh, 'A');
   fh->TotMode = P->Ps.NModes + CntExtra(fh, 'M');
   fh->TotIndex = (ex->smp_id != 2) ? 1 + CntExtra(fh, 'I') : 0;

  /******************************************************************/
  /* Establish enough space to set up the necessary information to  */
  /* identify what's to be returned.  We can set the Loc and Dim    */
  /* pointers at this time since they are fixed.                    */
  /******************************************************************/

   TotItems = fh->TotVSen + fh->TotAnc + fh->TotMode + fh->TotIndex;

   B = TotItems * (2 * sizeof(ByTe_2) + 4 * sizeof(ByTe_1));
   if ((fh->Order = (ByTe_2 *)malloc(B)) == NULL)
        idl_barf("make_idl_struct: malloc(Order)");

   fh->Units = fh->Order + TotItems;
   fh->uNDef = (ByTe_1 *)(fh->Units + TotItems);
   fh->Set = fh->uNDef + TotItems;
   fh->Loc = fh->Set + TotItems;
   fh->Dim = fh->Loc + TotItems;

  /********************************************************************/
  /* Count and tag the measurements in the PIDF Definitions and       */
  /* recalculate TotItems.  It might have shrunk                      */
  /********************************************************************/

   SetOrder (SENSOR, fh);
   SetOrder (ANCILLARY, fh);
   SetOrder (MODE, fh);
   SetOrder (SCAN_INDEX, fh);
   TotItems = fh->TotVSen + fh->TotAnc + fh->TotMode + fh->TotIndex;

   TaGs = NULL;
   TmpName = NULL;
   TmpDim = NULL;
   TmpType = NULL;
   MaxTag = -1;

  /********************************************************************/
  /* Do an initial malloc of the tag holding arrays                   */
  /********************************************************************/

   MaxTag = TotItems + 15;
   B = MaxTag * MAX_TAG_LEN;
   if ((TmpName = malloc(B)) == NULL)
      idl_barf("MkDataStruc: malloc(TmpName)");

   B = MaxTag * (4 * sizeof(IDL_MEMINT));
   if ((TmpDim = malloc(B)) == NULL)
       idl_barf("MkDataStruc: malloc(TmpDim)");

   B = MaxTag * sizeof(ByTe_2);
   if ((TmpType = malloc(B)) == NULL)
       idl_barf("MkDataStruc: malloc(TmpType)");

  /********************************************************************/
  /* This is where TmpSpace which is used to return the data in the   */
  /* convert_to_units call is malloced.  It just needs to be big      */
  /* enough to hold the largest returnable array.  If space already   */
  /* exists (say from a previous OPEN for another UDF) no need to     */
  /* do anything unless its too small                                 */  
  /********************************************************************/

   B = (fh->sType == IDL_TYP_FLOAT) ? (ex->swp_len + 4) * sizeof(ReaL_4) :
                                      (ex->swp_len + 4) * sizeof(ReaL_8);
   if (B > TmpBytes) {
      if (TmpSpace != NULL) { free (TmpSpace); }
      if ((TmpSpace = malloc( B)) == NULL)
         idl_barf("MkDataStruc: malloc(TmpSpace)");
      TmpBytes = B;
   }

  /*********BUG ALERT*******BUG ALERT*******BUG ALERT******BUG ALERT*******/
  /*                                                                      */
  /*  At this point the number of Columns in the data matrix is obtained. */
  /*  A value of 1 means not matrix data.  This value as far as I can see */
  /*  is obtained once!  Matrix sizes can change within a UDF file!       */
  /*  This does not seem to be taken into account!                        */
  /*                                                                      */
  /*********BUG ALERT*******BUG ALERT*******BUG ALERT******BUG ALERT*******/

  /**********************************************************************/
  /*  OK - NOW FOR THE STRUCTURE!                                       */
  /*                                                                    */
  /*  Always a start and a stop time and a length of data in sensor     */
  /**********************************************************************/

   Dim[0] = 0;
   Dim[1] = 0;
   Dim[2] = 0;
   lS = SetUpTag ("BTIME", UDF_TIME, Dim, nTag++, &MaxTag);
   lS = SetUpTag ("ETIME", UDF_TIME, Dim, nTag++, &MaxTag);
   lS = SetUpTag ("DLEN", IDL_TYP_LONG, Dim, nTag++, &MaxTag);
   lS = SetUpTag ("SPINPER", IDL_TYP_LONG, Dim, nTag++, &MaxTag);

  /**********************************************************************/
  /*  Always some data quality flags - but how many?                    */
  /*                                                                    */
  /*  One per sensor at least but if this is a matrix sensor then there */
  /*  is one per matrix column                                          */
  /**********************************************************************/

   SetDims (fh, Dim, 6, 0);
   lS = SetUpTag ("D_QUAL", IDL_TYP_FLOAT, Dim, nTag++, &MaxTag);

  /**********************************************************************/
  /*  Always some azimuth data, start and stop.  How many here depends  */
  /*  on how and if the keyword was set.  You get choices of 0) just    */
  /*  give it for the first sensor or 1) give it for all sensors.  In   */
  /*  the latter case you get it for all matrix elements if the data    */
  /*  is stored in matrix format.                                       */ 
  /**********************************************************************/

   SetDims (fh, Dim, 0, 0);
   lS = SetUpTag ("START_AZ", IDL_TYP_FLOAT, Dim, nTag++, &MaxTag);
   lS = SetUpTag ("STOP_AZ", IDL_TYP_FLOAT, Dim, nTag++, &MaxTag);

  /**********************************************************************/
  /*  Always some theta data, start and stop.  How many here depends    */
  /*  on how and if the keyword was set.  You get choices of 0) just    */
  /*  give it once per sensor or if matrix once per sensor per matrix   */
  /*  column;  1) give it for each element in the sensors and for       */
  /*  matrix data once for each matrix element.                         */
  /**********************************************************************/

   SetDims (fh, Dim, 1, 0);
   lS = SetUpTag ("START_TH", IDL_TYP_FLOAT, Dim, nTag++, &MaxTag);
   lS = SetUpTag ("STOP_TH", IDL_TYP_FLOAT, Dim, nTag++, &MaxTag);

  /**********************************************************************/
  /*  Throw in the array indices but only if this is an array or matrix */
  /*   UDF. Same storage scheme as the azimuth data                     */
  /**********************************************************************/

   if (ex->smp_id != 2) {
      FillUnits (SCAN_INDEX, fh);
      SetDims (fh, Dim, 2, 0);
      c1 = fh->uNDef + fh->TotVSen + fh->TotAnc + fh->TotMode;
      for (N = 0; N < fh->TotIndex; ++N, ++c1)
      {
         if (*c1 == 0)
            sprintf (Name, "AINDICES");
         else
            sprintf (Name, "AINDICES_V%d",*c1);
         lS = SetUpTag(Name, IDL_TYP_FLOAT, Dim, nTag++, &MaxTag);
      }
   }
 
  /**********************************************************************/
  /*  OK - create the data structures                                   */
  /**********************************************************************/

   FillUnits (SENSOR, fh);
   if (fh->flags.sformat == 1) {
      SetDims (fh, Dim, 5, 0);
      lS = SetUpTag("ALLSDATA", fh->sType, Dim, nTag++, &MaxTag);
      fh->TotSeN = 1;
   } else {
      SetDims (fh, Dim, 5, 0);
      s1 = fh->Order;
      c1 = fh->uNDef;
      for (N=0; N < fh->TotVSen; N++, ++c1) {
         TagName (Px[*s1++].Name, Tname);
         if (*c1 != 0) {
            sprintf (Name, "%s_V%d",Tname, *c1);
         } else { sprintf (Name, "%s", Tname); }
         lS = SetUpTag(Name, fh->sType, Dim, nTag++, &MaxTag);
         ++fh->TotSeN;
      }
   }

  /**********************************************************************/
  /*  Next do modes if there are any around                             */
  /**********************************************************************/

   if (fh->TotMode > 0) {
      FillUnits (MODE, fh);
      SetDims (fh, Dim, 7, 0);
      s1 = fh->Order + fh->TotVSen + fh->TotAnc;
      c1 = fh->uNDef + fh->TotVSen + fh->TotAnc;
      for (N = 0; N < fh->TotMode; N++, ++c1) {
         TagName (Pm[*s1++].LDesc, Tname);
         if (*c1 != 0)
            sprintf (Name, "%s_V%d",Tname, *c1);
         else
            sprintf (Name, "%s", Tname);
         lS = SetUpTag(Name, fh->sType, Dim, nTag++, &MaxTag);
      } 
   }
 
  /**********************************************************************/
  /*  And last try some ancillary data sets                             */
  /**********************************************************************/

   if (fh->TotAnc > 0) {
      FillUnits (ANCILLARY, fh);
      s1 = fh->Order + fh->TotVSen;
      c1 = fh->uNDef + fh->TotVSen;
      c2 = fh->Loc + fh->TotVSen;
      for (N = 0; N < fh->TotAnc; N++, ++c1, ++c2) {
         Dim[0] = N;
         SetDims (fh, Dim, 8, 0);
         if (*c2 == 'S') 
            TagName (Px[*s1++].Name, Tname);
         else
            TagName (Pa[*s1++].LDesc, Tname);
         if (*c1 != 0)
            sprintf (Name, "%s_V%d",Tname, *c1);
         else
            sprintf (Name, "%s", Tname);
         lS = SetUpTag (Name, fh->sType, Dim, nTag++, &MaxTag);
      } 
   } 
   /***********************************************************************/
   /*  Not sure why we need this extra pad but without it you can not do  */
   /*  multiple UDF_READS.  So for now it stays                           */
   /***********************************************************************/


   FormTags (nTag);
   dS = IDL_MakeStruct((ByTe_1 *)NULL, TaGs);
   lS += IDL_StructTagInfoByIndex(dS, (int)(nTag - 1), 0, (IDL_VPTR *)0);
   fh->dSize = lS + 1000;

   free (TaGs);
   free (TmpName);
   free (TmpDim);
   free (TmpType);

   return dS;
}
