#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "Util1Ansi.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void ImportFree(UCHAR* pTr)
{
   extern struct fh_cache fh_list[];

   struct fh_cache *fh;
   ByTe_4 I, J;

  /************************************************************************/
  /*  SEE if we can match this memory block to be freed to one that we    */
  /*  we created                                                          */
  /************************************************************************/

   for (I = 0; I < MAX_OPEN; ++I) {
      if ( fh_list[I].Key == 0 ) { continue; }
      fh = &fh_list[I];

  /************************************************************************/
  /* Check the VIDF memory.  If we get a match need to also free any      */
  /*   associated string memory which is in mV element                    */
  /************************************************************************/

      for (J = 0; J < fh->vNum; ++J) {
         if (fh->vA[J] == pTr) {
            if (fh->vA[J] != NULL) {
               free(fh->vA[J]);
               fh->vA[J] = NULL;
            }
            if (fh->mV[J] != NULL) {
               free(fh->mV[J]);
               fh->mV[J] = NULL;
            }
            return;
         }
      }

  /************************************************************************/
  /* Check the Data memory                                                */
  /************************************************************************/

      if (fh->dA == pTr) {
         if (fh->dA != NULL) {
            free(fh->dA);
            fh->dA = NULL;
	    return;
         }
      }
   }
}
