#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"
#include "udfdlm_str.h"

void FormTags (ByTe_4 nTag)
{
   extern void *s_udf_time;
   extern void *TaGs;
   extern void *TmpName;
   extern void *TmpDim;
   extern void *TmpType;

   IDL_STRUCT_TAG_DEF *T1;
   IDL_MEMINT *l1;
   size_t B;
   ByTe_2 *s1, *EnD;
   ByTe_1 *c1;

  /***********************************************************************/
  /* GET memory for the tag structures                                   */
  /***********************************************************************/

   B = (nTag + 1) * sizeof(IDL_STRUCT_TAG_DEF);
   if ((TaGs = malloc(B)) == NULL) {
       idl_barf("FormTags: malloc(TaGs)");
   }

  /***********************************************************************/
  /* Pointers to where the tag information is                            */
  /***********************************************************************/

   T1 = (IDL_STRUCT_TAG_DEF *)TaGs;
   l1 = (IDL_MEMINT *)TmpDim;
   s1 = (ByTe_2 *)TmpType;
   EnD = s1 + nTag;
   c1 = (ByTe_1 *)TmpName;

  /***********************************************************************/
  /* Form the tags                                                       */
  /***********************************************************************/

   for ( ; s1 < EnD; c1 += MAX_TAG_LEN, l1 += 4, ++s1, ++T1) {
      T1->name = c1;
      T1->flags = 0;
      T1->dims = l1;
      switch (*s1) {
         case 0: 
           T1->type = s_udf_time;
         break;
         case 1: 
           T1->type = (void *)IDL_TYP_BYTE;
         break;
         case 2: 
           T1->type = (void *)IDL_TYP_LONG;
         break;
         case 3: 
           T1->type = (void *)IDL_TYP_FLOAT;
         break;
         case 4: 
           T1->type = (void *)IDL_TYP_DOUBLE;
         break;
         case 5: 
           T1->type = (void *)IDL_TYP_STRING;
         break;
         case 6: 
           T1->type = (void *)IDL_TYP_ULONG;
         break;
         case 7: 
           T1->type = (void *)IDL_TYP_INT;
         break;
         case 8: 
           T1->type = (void *)IDL_TYP_UINT;
         break;
      }
   }

   T1->name = 0;
   
}
