#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

ByTe_4 FindFh (u_ByTe_4 Key)
{
   extern struct fh_cache fh_list[];

   static ByTe_1 First = 1;

   struct fh_cache *fh;
   ByTe_4 free_fh;

  /************************************************************************/
  /*  IF this is the first time called set all Keys to 0                  */
  /************************************************************************/

   if (First) {
      First = 0;
      for (free_fh = 0; free_fh < MAX_OPEN; ++free_fh)
          fh_list[free_fh].Key = 0;
   }

  /************************************************************************/
  /*  Given a UDF Key match it up with a file handle structure.  If one   */
  /*  doesn't exist then assign one to the key.                           */
  /************************************************************************/

  for (free_fh = 0; free_fh < MAX_OPEN; ++free_fh)
      if (fh_list[free_fh].Key == Key)
         break;

  /* We haven't seen this key before... now look for an empty slot */


   if (free_fh == MAX_OPEN) {
      for (free_fh = 0; free_fh < MAX_OPEN; free_fh++) {
         if (fh_list[free_fh].Key == 0)
            break;
      }

      if (free_fh == MAX_OPEN)
         idl_barf("too many open UDFs; limit is %d\n", MAX_OPEN);

       fh = &fh_list[free_fh];
       fh->Key = Key;
       fh->PIDF = NULL;
       fh->Units = NULL;
       fh->Order = NULL;
       fh->pInfo = NULL;
       fh->dA = NULL;
       fh->vA = NULL;
       fh->mV = NULL;
       fh->dSize = 0;
       fh->vNum = 0;
       fh->TotSeN = 0;
       fh->sdef = NULL;
       fh->is_open = 0;
       fh->tV = 0;
       fh->flags.baseunit = 1;
       fh->flags.gotkeys = 0;
       fh->LastRead = 999;
   }

   return (free_fh);
}
