#ifndef __UDF_DLM_DEFS_H
#define __UDF_DLM_DEFS_H 1

#define MAX_TAG_LEN   80
#define MAX_TAGS      20
#define MAX_BEGS      15
#define MAX_UNITS    512
#define MAX_OPEN     100
#define FHANDLE_BASE 601

/* These are the Begs array elements which contain the offsets into the */
/* the data array at which data for various UDF data definitions are to */
/* be loaded.  The ANC location must be the last since it is the start  */
/* location for the ancillary data which has one location per returned  */
/* ancillary data set                                                   */

#define _BTIME_    0
#define _ETIME_    1
#define _DLEN_     2
#define _SPINPER_  3
#define _BPHASE_   4
#define _EPHASE_   5
#define _BTHETA_   6
#define _ETHETA_   7
#define _INDEX_    8
#define _SENSOR_   9
#define _MODE_    10
#define _QUAL_    11
#define _ANC_     12

#define FG(a,b,c)					\
		if (FieldGetN(a,b,c) != SUCCESS)	\
		  idl_barf("db_get(%s)",b)

#define SECONDS_PER_DAY		(86400)
#define PROCEDURE void
#define FUNCTION  IDL_VPTR

#define UDF_TIME  -1

#define SCALAR  1
#define ARRAY   2
#define MATRIX  3

#endif  /* __UDF_DLM_DEFS_H */
