#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void udfdlm_time_fill( struct udf_time *utime, ByTe_4 yy, ByTe_4 doy, 
                                                          ByTe_4 ms )
{
  /*
  ** "dp" field is for the user's convenience.  It can be anything,
  ** but we initialize it to a day number based on Jan 1 2000, because
  ** that's what Ed likes.
  */
  utime->dp    = floor((yy - 2000) * 365.25)
                 + doy - (yy % 4 == 0)
                 + ((double)ms / ((double)SECONDS_PER_DAY*1000.0));

  utime->year  = yy;
  utime->doy   = doy;

  utime->msec  = (unsigned short)(ms % 1000);  ms /= 1000;
  utime->sec   = (unsigned char) (ms % 60);    ms /= 60;
  utime->min   = (unsigned char) (ms % 60);    ms /= 60;
  utime->hour  = (unsigned char) ms;
}
