#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "Util1Ansi.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/**************\
|*  UDF_VIDF  *|  Read various VIDF information
\**************/

FUNCTION UDF_VIDF(int Argc, IDL_VPTR Argv[], char *kw_unused)
{
   extern struct fh_cache fh_list[];
   extern ByTe_1 Ext[];
   extern u_ByTe_2 Version;

   struct fh_cache *fh;
   struct basic_struct *arr;
   ByTe_1 *mB;

   IDL_MEMINT  one = 1;
   IDL_VPTR    *vP;

   ReaL_8    *rV;
   u_ByTe_4  KeY;
   size_t    mS, sS, B;
   ByTe_4    FhNum, I, N;
   ByTe_4   nTS, nTV, cAS, EnD;
   ByTe_4   tO, *Val, tSz, lH;
   int      eN;
   ByTe_2   tL;
   u_ByTe_2 VeR;
   ByTe_2   vFmT = 0;
   ByTe_2   sH, nCom, nSen, PaAppS;
   ByTe_1   cH, FillFlag, nAnc, nQual, pAng, nStat, tType;
   ByTe_1   *tP;
   ByTe_1   *tS, *Sca;
   ByTe_1   nT, nC;
   ByTe_1   *SecTioN;
   ByTe_2   Block = 0;
   ByTe_2   TyPe, mN = 0, sV = 0;
   void     *vD;
   void     *Va;
   void     *tScratch;
   void     *dS;

/* GET the offset to the file handler which holds the information on the */
/* (hopefully) open UDF definition whose VIDF is to be accessed          */

   if (Argc >= 2) {
      FhNum = Argv[0]->value.i;
      fh = &fh_list[FhNum];
      if (Argv[1]->type != IDL_TYP_STRING) {
         idl_barf("UDF_VIDF: SECTION - Must Be a String Argument");
      } else { SecTioN = IDL_STRING_STR(&Argv[1]->value.str); }
   } else
      IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, "Usage: uM = UDF_VIDF(fh)");

/* GET what portion of the VIDF is being returned                         */

   if (Argc > 2) {
     TyPe =  Argv[2]->type;
     Block = (TyPe == IDL_TYP_INT) ? Argv[2]->value.i : Argv[2]->value.l;
   }

/* IF its a cooked table get the sensor whose values are being returned   */

   if (Argc > 3) {
     TyPe =  Argv[3]->type;
     mN = (TyPe == IDL_TYP_INT) ? Argv[3]->value.i : Argv[3]->value.l;
   }

/* IF its a cooked table which has critical values associated with it get */
/* the status value to use when assembling the table values               */

   if (Argc > 4) {
     TyPe =  Argv[4]->type;
     sV = (TyPe == IDL_TYP_INT) ? Argv[3]->value.i : Argv[3]->value.l;
   }

   KeY = fh->Key;
   VeR = Version;
   tScratch = NULL;
   vP = 0;
   eN = 0;

   if ( strcmp(SecTioN, "BODY") == 0 )           { vFmT = 0; }
   if ( strcmp(SecTioN, "TABLERAW") == 0 )       { vFmT = 1; }
   if ( strcmp(SecTioN, "TABLECOOKED") == 0 )    { vFmT = 2; }
   if ( strcmp(SecTioN, "CONSTANTRAW") == 0 )    { vFmT = 3; }
   if ( strcmp(SecTioN, "CONSTANTCOOKED") == 0 ) { vFmT = 4; }

/* CREATE the IDL VIDF structure                                          */

   vD = MkVidfStruc(fh, vFmT, Block, mN, sV, &mS, &sS);

/* MyChoice is used to keep track of the number of bytes placed in the    */
/* the data structure.  Need to do this so that they can be correctly     */
/* aligned.                                                               */

   fh->MyChoice = 0;

/* GET the number of defined sensors, tables and constants in the VIDF.   */  

   read_idf(KeY, Ext, VeR, (ByTe_1 *)&nSen, _SeN, 0, 0, 0);
   read_idf(KeY, Ext, VeR, &nT, _NumTblS, 0, 0, 0);
   read_idf(KeY, Ext, VeR, &nC, _NumConstS, 0, 0, 0);

/* GET the data which depends on what was asked for.                      */  

   switch (vFmT) {
      case 0:
         I = 0;

/* Get memmory to hold the string data associated with the VIDF body.     */ 
/* This memory needs to be kept so long as the IDL structure is being     */
/* used.                                                                  */
        
	 if (fh->vA[I] == NULL) { 
            if ((fh->vA[I] = malloc(mS)) == NULL) {
               idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");
            }
         }

         arr = (struct basic_struct *)fh->vA[I];
         mB = (ByTe_1 *) &(arr->data);

	 if (fh->mV[I] == NULL) {
            if ((fh->mV[I] = malloc(sS)) == NULL) {
               idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");
            }
         } 
         tP = (ByTe_1 *)fh->mV[I];
 
 /* GET the amounts of some of the data which will be obtained            */
   
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _NumComntS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &FillFlag, _FillFlaG, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nStat, _StatuS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nAnc, _CalSetS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nQual, _NumQuaL, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &pAng, _PaDefineD, 0, 0, 0);

/* MALLOC some temporary scratch space to hold some VIDF arrays           */

         B = sizeof(ByTe_4) * (nSen + nAnc + nStat + 40);
         if ((tScratch = malloc(B)) == NULL) {
             idl_barf("UDF_VIDF: malloc(tScratch) failed!");
         }
         tS = (ByTe_1 *)tScratch;

         read_idf(KeY, Ext, VeR, tP, _ProjecT, 0, 0, 0);
	 StoreData(vD, mB, tP, 0, 0, eN++, 1, 0); 
         tP += 80;

         read_idf(KeY, Ext, VeR, tP, _MissioN, 0, 0, 0);
	 StoreData(vD, mB, tP, 0, 0, eN++, 1, 0); 
         tP += 80;

         read_idf(KeY, Ext, VeR, tP, _ExpDesC, 0, 0, 0);
	 StoreData(vD, mB, tP, 0, 0, eN++, 1, 0); 
         tP += 80;

         read_idf(KeY, Ext, VeR, tP, _InstDesC, 0, 0, 0);
	 StoreData(vD, mB, tP, 0, 0, eN++, 1, 0); 
         tP += 80;
      
         read_idf(KeY, Ext, VeR, tP, _ContacT, 0, 0, 0);
	 StoreData(vD, mB, tP, 0, 0, eN++, 5, 0); 
	 tP += 400;
      
	 StoreData(vD, mB, (ByTe_1 *)&nCom, 1, 2, eN++, 1, 0); 

         if ( nCom > 0 ) {
            read_idf(KeY, Ext, VeR, tP, _CommentS, 0, 0, 0);
	    StoreData(vD, mB, tP, 0, 0, eN++, nCom, 0); 
	    tP += nCom * 80;
         }

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DsYeaR, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&sH, 1, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DsDaY, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&sH, 1, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&lH, _DsMseC, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&lH, 2, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DsUseC, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&sH, 1, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DeYeaR, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&sH, 1, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DeDaY, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&sH, 1, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&lH, _DeMseC, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&lH, 2, 2, eN++, 1, 0); 
         
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _DeUseC, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&sH, 1, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _SmpID, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _SenModE, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _NumQuaL, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _CalSetS, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _NumTblS, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _NumConstS, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _StatuS, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _PaDefineD, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _SeN, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&sH, 1, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _SwpLeN, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&sH, 1, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _MaxNsS, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&sH, 1, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&lH, _DataLeN, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&lH, 2, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _FillFlaG, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         if (FillFlag == 1) { 
            read_idf(KeY, Ext, VeR, (ByTe_1 *)&lH, _FilL, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)&lH, 2, 2, eN++, 1, 0); 
         }

         read_idf(KeY, Ext, VeR, &cH, _DaMethoD, 0, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         if (nStat > 0) { 
            read_idf(KeY, Ext, VeR, tP, _StatusNamE, 0, 0, 0);
	    StoreData(vD, mB, tP, 0, 0, eN++, nStat, 0); 
	    tP += nStat * 80;
      
            read_idf(KeY, Ext, VeR, tS, _StateS, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 0, 2, eN++, nStat, 0); 
         }
      
         if (nSen > 0) { 
            read_idf(KeY, Ext, VeR, tP, _SenNamE, 0, 0, 0);
	    StoreData(vD, mB, tP, 0, 0, eN++, nSen, 0); 
	    tP += nSen * 80;
      
            read_idf(KeY, Ext, VeR, tS, _DataTypE, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 0, 2, eN++, nSen, 0); 
      
            read_idf(KeY, Ext, VeR, tS, _TdwLeN, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 0, 2, eN++, nSen, 0); 
      
            read_idf(KeY, Ext, VeR, tS, _TimeOfF, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 2, 2, eN++, nSen, 0); 
         }
      
         if (nAnc > 0) { 
            read_idf(KeY, Ext, VeR, tP, _CalNameS, 0, 0, 0);
	    StoreData(vD, mB, tP, 0, 0, eN++, nAnc, 0); 
	    tP += nAnc * 80;
      
            read_idf(KeY, Ext, VeR, tS, _CalUsE, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 0, 2, eN++, nAnc, 0); 
      
            read_idf(KeY, Ext, VeR, tS, _CalWleN, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 0, 2, eN++, nAnc, 0); 
      
            read_idf(KeY, Ext, VeR, tS, _CalTargeT, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 0, 2, eN++, nAnc, 0); 
         }
      
         if (nQual > 0) { 
            read_idf(KeY, Ext, VeR, tP, _QualNamE, 0, 0, 0);
	    StoreData(vD, mB, tP, 0, 0, eN++, nQual, 0); 
	    tP += nQual * 80;
         }

         if (pAng == 1) { 
            read_idf(KeY, Ext, VeR, tP, _PaProjecT, 0, 0, 0);
	    StoreData(vD, mB, tP, 0, 1, eN++, 1, 0); 
            tP += 21;
            read_idf(KeY, Ext, VeR, tP, _PaMissioN, 0, 0, 0);
	    StoreData(vD, mB, tP, 0, 1, eN++, 1, 0); 
            tP += 21;
            read_idf(KeY, Ext, VeR, tP, _PaExpeR, 0, 0, 0);
	    StoreData(vD, mB, tP, 0, 1, eN++, 1, 0); 
            tP += 21;
            read_idf(KeY, Ext, VeR, tP, _PaInsT, 0, 0, 0);
	    StoreData(vD, mB, tP, 0, 1, eN++, 1, 0); 
            tP += 21;
            read_idf(KeY, Ext, VeR, tP, _PaVinsT, 0, 0, 0);
	    StoreData(vD, mB, tP, 0, 1, eN++, 1, 0); 
            tP += 21;
      
            read_idf(KeY, Ext, VeR, (ByTe_1 *)&sH, _PaFormaT, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)&sH, 1, 2, eN++, 1, 0); 

            read_idf(KeY, Ext, VeR, tS, _PaBxbybZ, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 1, 2, eN++, 3, 0); 
      
            read_idf(KeY, Ext, VeR, (ByTe_1 *)&PaAppS, _PaAppS, 0, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)&PaAppS, 1, 2, eN++, 1, 0); 
            if ( sH > 0 ) {
               read_idf(KeY, Ext, VeR, tS, _PaTblS, 0, 0, 0);
	       StoreData(vD, mB, (ByTe_1 *)tS, 1, 2, eN++, PaAppS, 0); 
      
               read_idf(KeY, Ext, VeR, tS, _PaOpS, 0, 0, 0);
	       StoreData(vD, mB, (ByTe_1 *)tS, 1, 2, eN++, PaAppS, 0); 
            }
         }

      break;
      case 1:
         I = Block * 2 + 1;

	 if (fh->vA[I] == NULL) {
            if ((fh->vA[I] = malloc(mS)) == NULL) {
               idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");
            }
         }

         arr = (struct basic_struct *)fh->vA[I];
         mB = (ByTe_1 *) &(arr->data);

	 if (fh->mV[I] == NULL) {
            if ((fh->mV[I] = malloc(sS)) == NULL) {
               idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");
            }
         } 
         tP = (ByTe_1 *)fh->mV[I];

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _TblDescLeN, Block, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nTS, _TblScaSZ, Block, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nTV, _TblEleSZ, Block, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&cAS, _CritActSZ, Block, 0, 0);
         read_idf(KeY, Ext, VeR, &tType, _TblTypE, Block, 0, 0);

	 B = (nTS < 0) ? -nTS : nTS;
         B = sizeof(ByTe_4) * (B + nSen + cAS + 40);
         if ((tScratch = malloc(B)) == NULL) {
             idl_barf("UDF_VIDF: malloc(tScratch) failed!");
         }
         tS = (ByTe_1 *)tScratch;

	 StoreData(vD, mB, (ByTe_1 *)&nTS, 2, 2, eN++, 1, 0); 
	 StoreData(vD, mB, (ByTe_1 *)&nTV, 2, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _TblTypE, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

	 StoreData(vD, mB, (ByTe_1 *)&nCom, 1, 2, eN++, 1, 0); 

         if ( nCom > 0 ) {
            read_idf(KeY, Ext, VeR, tP, _TblDesC, Block, 0, 0);
	    StoreData(vD, mB, tP, 0, 0, eN++, nCom, 0); 
            tP += nCom * 80;
         }

         read_idf(KeY, Ext, VeR, &cH, _TblVaR, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _TblExpanD, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

	 if ( cAS > 0 ) {
            read_idf(KeY, Ext, VeR, tS, _CritStatuS, Block, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 0, 2, eN++, nSen, 0); 

            read_idf(KeY, Ext, VeR, tS, _CritOfF, Block, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 1, 2, eN++, nSen, 0); 

            read_idf(KeY, Ext, VeR, tS, _CritActioN, Block, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 2, 2, eN++, cAS, 0); 
	 }

         read_idf(KeY, Ext, VeR, tS, _TblFmT, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)tS, 0, 2, eN++, nSen, 0); 

         read_idf(KeY, Ext, VeR, tS, _TblOfF, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)tS, 2, 2, eN++, nSen, 0); 

         if ( nTS != 0 ) {
	    EnD = (nTS < 0) ? -nTS : nTS;
            read_idf(KeY, Ext, VeR, tS, _TblScA, Block, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 0, 2, eN++, EnD, 0); 
         }

         if (tType != 1 ) {
            read_idf(KeY, Ext, VeR, tS, _TbL, Block, 0, 0);
	    StoreData(vD, mB, (ByTe_1 *)tS, 2, 2, eN++, nTV, 0); 
         } else {
            read_idf(KeY, Ext, VeR, tP, _TbL, Block, 0, 0);
	    StoreData(vD, mB, tP, 0, 1, eN++, nTV, 0); 
            tP += nTV * 21;
	 }

      break;
      case 2:
         I = Block * 2 + 2;

/* Get memmory to hold the string data associated with the VIDF table.    */ 
/* This memory needs to be kept so long as the IDL structure is being     */
/* used.                                                                  */

	 if (fh->vA[I] == NULL) { 
            if ((fh->vA[I] = malloc(mS)) == NULL) {
               idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");
            }
         }
          
         arr = (struct basic_struct *)fh->vA[I];
         mB = (ByTe_1 *) &(arr->data);

	 if (fh->mV[I] == NULL) {
            if ((fh->mV[I] = malloc(sS)) == NULL) {
               idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");
            }
         } 

/* Pointer to string memeory                                             */

         tP = (ByTe_1 *)fh->mV[I];

/* READ the number of lines in the table description and what type of    */
/* table this is.                                                        */

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _TblDescLeN, Block, 0, 0);
         read_idf(KeY, Ext, VeR, &tType, _TblTypE, Block, 0, 0);

         read_idf(KeY, Ext, VeR, &cH, _TblTypE, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

	 StoreData(vD, mB, (ByTe_1 *)&nCom, 1, 2, eN++, 1, 0); 

         if ( nCom > 0 ) {
            read_idf(KeY, Ext, VeR, tP, _TblDesC, Block, 0, 0);
	    StoreData(vD, mB, tP, 0, 0, eN++, nCom, 0); 
            tP += nCom * 80;
         }

         read_idf(KeY, Ext, VeR, &cH, _TblVaR, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

         read_idf(KeY, Ext, VeR, &cH, _TblFmT, Block, mN, 1);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

	 tL = NumTblVals (KeY, Block, mN);
         if (tL > 0) {
            if (tType != 1 ) {
	       tO = TblOffset (KeY, Block, mN, sV);

               read_idf(KeY, Ext, VeR, &tType, _TblTypE, Block, 0, 0);

               B = tL * (2 * sizeof(ByTe_4) + sizeof(ReaL_8));
               if ((Va = malloc (B)) == NULL)  
                   idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");

               rV = (ReaL_8 *)Va;
               Val = (ByTe_4 *)(rV + tL);
               Sca = (ByTe_1 *)(Val + tL);

               read_idf(KeY, Ext, VeR, (ByTe_1 *)Val, _TbL, Block, tO, tL);
               read_idf(KeY, Ext, VeR, (ByTe_1 *)&tSz, _TblScaSZ, Block, 0, 0);

               if ( tSz < 0 ) {
                  read_idf(KeY, Ext, VeR, Sca, _TblScA, Block, mN, 1);
                  for (N = 0; N < tL; ++N) {
                     *rV++ = (ReaL_8)*Val++ * pow(10.0,(ReaL_8)*Sca);
                  }
               } else {
                  read_idf(KeY, Ext, VeR, Sca, _TblScA, Block, tO, tL);
                  for (N = 0; N < tL; ++N) {
                     *rV++ = (ReaL_8)*Val++ * pow(10.0,(ReaL_8)*Sca++);
                  }
               }

	       StoreData(vD, mB, (ByTe_1 *)Va, 4, 4, eN++, tL, 0); 
               free(Va);

            } else {
               read_idf(KeY, Ext, VeR, tP, _TbL, Block, tO, tL);
	       StoreData(vD, mB, tP, 0, 1, eN++, tL, 0); 
               tP += nTV * 21;
            }
	 }
      break;
      case 3:
         I = nT * 2 + Block * 2 + 1;

	 if (fh->vA[I] == NULL) { 
            if ((fh->vA[I] = malloc(mS)) == NULL) {
               idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");
            }
	 }

         arr = (struct basic_struct *)fh->vA[I];
         mB = (ByTe_1 *) &(arr->data);

	 if (fh->mV[I] == NULL) {
            if ((fh->mV[I] = malloc(sS)) == NULL) {
               idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");
            }
         } 
         tP = (ByTe_1 *)fh->mV[I];

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _ConstDescLeN, Block, 0, 0);

         B = sizeof(ByTe_4) * nSen;
         if ((tScratch = malloc(B)) == NULL) {
             idl_barf("UDF_VIDF: malloc(tScratch) failed!");
         }
         tS = (ByTe_1 *)tScratch;

         read_idf(KeY, Ext, VeR, &cH, _ConstID, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

	 StoreData(vD, mB, (ByTe_1 *)&nCom, 1, 2, eN++, 1, 0); 

         if ( nCom > 0 ) {
            read_idf(KeY, Ext, VeR, tP, _ConstDesC, Block, 0, 0);
	    StoreData(vD, mB, tP, 0, 0, eN++, nCom, 0); 
            tP += nCom * 80;
         }

         read_idf(KeY, Ext, VeR, tS, _ConstScA, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)tS, 0, 2, eN++, nSen, 0); 

         read_idf(KeY, Ext, VeR, tS, _ConsT, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)tS, 2, 2, eN++, nSen, 0); 

      break;
      case 4:
         I = nT * 2 + Block * 2 + 2;

	 if (fh->vA[I] == NULL) {
            if ((fh->vA[I] = malloc(mS)) == NULL) {
               idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");
            }
         }
          
         arr = (struct basic_struct *)fh->vA[I];
         mB = (ByTe_1 *) &(arr->data);

	 if (fh->mV[I] == NULL) {
            if ((fh->mV[I] = malloc(sS)) == NULL) {
               idl_barf("UDF_VIDF: malloc(fh->mV[I]) failed!");
            }
         } 
         tP = (ByTe_1 *)fh->mV[I];

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _ConstDescLeN, Block, 0, 0);

         B = nSen * (2 * sizeof(ByTe_4) + sizeof(ReaL_8));
         if ((tScratch = malloc(B)) == NULL) {
             idl_barf("UDF_VIDF: malloc(tScratch) failed!");
         }
         tS = (ByTe_1 *)tScratch;

         read_idf(KeY, Ext, VeR, &cH, _ConstID, Block, 0, 0);
	 StoreData(vD, mB, (ByTe_1 *)&cH, 0, 2, eN++, 1, 0); 

	 StoreData(vD, mB, (ByTe_1 *)&nCom, 1, 2, eN++, 1, 0); 

         if ( nCom > 0 ) {
            read_idf(KeY, Ext, VeR, tP, _ConstDesC, Block, 0, 0);
	    StoreData(vD, mB, tP, 0, 0, eN++, nCom, 0); 
            tP += nCom * 80;
         }

         rV =  (ReaL_8 *)tS;
         Val = (ByTe_4 *)(rV + tL);
         Sca = (ByTe_1 *)(Val + tL);

         read_idf(KeY, Ext, VeR, Sca, _ConstScA, Block, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)Val, _ConsT, Block, 0, 0);

	 for ( I = 0; I < nSen; ++I ) {
	    *rV++ = (ReaL_8)*Val++ * pow(10,(ReaL_8)*Sca++);  
	 }
	 StoreData(vD, mB, (ByTe_1 *)tS, 4, 4, eN++, tL, 0); 

      break;
   }

   if (tScratch != NULL) { free(tScratch); }

   dS =  IDL_ImportArray(1, &one, IDL_TYP_STRUCT, (UCHAR*)arr, ImportFree, vD);
/*
   dS =  IDL_ImportArray(1, &one, IDL_TYP_STRUCT, (UCHAR*)arr, NULL, vD);
*/


   return dS;
}
