#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "util_str.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libbase_udf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void SetDims(struct fh_cache *fh, ByTe_4 *D, ByTe_1 Item, ByTe_4 NuM)
{
   extern struct general_info ginfo;

   struct experiment_info *ex;
   extern u_ByTe_2 Version;
   extern ByTe_1 Ext[];

   ByTe_4 kW;
   struct Pidf         *P;
   struct PidfSensor   *Px;
   struct PidfAnc      *Pa;

   register ByTe_4 *l1;
   register ByTe_2 *s1;
   ByTe_2 Rv;
   ByTe_4 N, vN, Len, pN, Pos;
   ByTe_1 *c1;

   Rv = ir_locate_ex (fh->Key, Ext, Version, 0);
   if (Rv == ALL_OKAY) {
      ex = ginfo.expt;
   } else { udf_barf("LOCATE_EX", Rv); }

   l1 = D;
   N = *l1;
   *l1++ = 0;
   *l1++ = 0;
   *l1 = 0;
   l1 = D;

   switch (Item)
   {
      case 0:                                                    /* Azimuth */
      case 2:                                                    /* ArIndex */
        kW = (Item == 0) ? fh->flags.azimuth : fh->flags.indices;
        if (kW == 0)
           *l1 = ex->swp_len;
        else {
           if (fh->NCols == 1)
           {
              *l1++ = ex->swp_len;
              *l1 = fh->TotVSen;
           } else {
              *l1++ = ex->swp_len;
              *l1++ = fh->NCols;
              *l1 = fh->TotVSen;
           }
        }
      break;
      case 1:                                                    /* Theta */
        if (fh->flags.theta == 0 || ex->swp_len == 1)
        {
           if (fh->NCols == 1)
              *l1 = fh->TotVSen;
           else { 
              *l1++ = fh->NCols;
              *l1 = fh->TotVSen;
           }
        } else {
           if (fh->NCols == 1) {
              *l1++ = ex->swp_len;
              *l1 = fh->TotVSen;
           } else {
              *l1++ = ex->swp_len;
              *l1++ = fh->NCols;
              *l1 = fh->TotVSen;
           }
        }
      break;
      case 3:                                            /* Collapse Data */
        if (ex->swp_len == 1)
           *l1 = fh->TotVSen;
        else {
           if (fh->NCols == 1) {
              *l1++ = ex->swp_len;
              *l1 = fh->TotVSen;
           } else {
              *l1++ = ex->swp_len;
              *l1++ = fh->NCols;
              *l1 = fh->TotVSen;
           }
        }
      break;
      case 5:                                             /* Data */
        if (fh->flags.sformat == 1) {
           if (fh->TotVSen == 1 && fh->NCols) {
              *l1 = ex->swp_len;
           } else {
              *l1++ = ex->swp_len;
              *l1 =  fh->TotVSen * fh->NCols;
           }
        } else {
           if (fh->NCols == 1) {
              *l1 = ex->swp_len;
           } else {
              *l1++ = ex->swp_len;
              *l1 = fh->NCols;
           }
        }
    
      break;
      case 6:                                             /* D_Qual Data */
        if (fh->NCols == 1) {
           *l1 = fh->TotVSen;
        } else {
           *l1 = fh->NCols;
           *l1++ = fh->TotVSen;
        }
      break;
      case 7:                                               /* Mode  Data */
        *l1 = 1;
      break;
      case 8:                                               /* Anc  Data */
        P = (struct Pidf *)fh->PIDF;
        Px = (struct PidfSensor *)P->Sensors;
        Pa = (struct PidfAnc *)P->Ancil;
        s1 = ex->CAL_USE;
        c1 = ex->cal_target;

        Pos = fh->TotVSen + N;
        pN = *(fh->Order + Pos);
        vN = (*(fh->Loc + Pos) == 'S') ? Px[pN].VidfNum : Pa[pN].VidfNum;

        switch (*(c1 + vN)) {                               /* by target  */
           case 0:
           case 1:
             Len = (*(s1 + vN) == 0) ? 1 : ex->swp_len;
             *(fh->Dim + Pos) = (Len == 1) ? 0 : 1;
             if (fh->NCols == 1)
             {
                if (Len == 1) {
                   *l1 = fh->TotVSen;
                }
                else {
                   *l1++ = Len;
                   *l1 = fh->TotVSen;
                }
             } else {
                if (Len == 1) {
                   *l1++ = fh->NCols;
                   *l1 = fh->TotVSen;
                }
                else {
                   *l1++ = Len;
                   *l1++ = fh->NCols;
                   *l1 = fh->TotVSen;
                }
             }
           break;
           case 2:
             *l1 = fh->NCols;
             *(fh->Dim + Pos) = 0;
           break;
           case 3:
             *l1 = 1;
             *(fh->Dim + Pos) = 0;
           break;
        }

      break;
   }
}
