#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/***************\
|*  UDF_TIMES  *|  Given a key, return an array of times available in the UDF
\***************/

FUNCTION UDF_TIMES(int Argc, IDL_VPTR Argv[], char *kw_unused)
{
   extern void *s_udf_times;
   int dbf, ndx;
   u_ByTe_4 Key;
   char fname[1024];
   char *path;

  /* UDF database keys */

   extern LinkList Projects;
   StrHier         scode;
   ByTe_2          field_ids[5];

   struct udf_times *udf_times_list;

  /* counters */

   IDL_LONG i, maxrec;
   IDL_MEMINT nr;

  /*
  ** There's only one possible way to invoke us.  Anything else, and choke.
  */

  if (Argc != 1)
    IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, "Usage: dT = UDF_TIMES(Key)");

  /* Extract the KEY argument from the parameter list */

  Key = Argv[0]->value.ul;

  /* From the key, determine the full proj/miss/exp/inst/vinst path */

  key_to_fields(Key, field_ids);
  scode = SourceByNum(Projects, field_ids[0], field_ids[1], field_ids[2],
                                field_ids[3], field_ids[4], NULL);

  /* ...and from that, obtain a path to the database */

  path = DbfFile(scode);
  sprintf(fname, "%s.HD.DBF", path);

  /* Open the database, or die trying */

  if (OpenDbf(&dbf, fname, 0) != SUCCESS)
     idl_barf("UDF_TIMES: OpenDbf(%s) failed", fname);
  ndx = -1;

  GoToTop(dbf, ndx);

  /* As a first guess, assume 4 VINSTs per instrument */
  maxrec = mNumRecs(dbf) / 4;
  if (maxrec < 1)
    maxrec = 1;

  /* Grab a chunk of space for the returned struct */
  udf_times_list = (struct udf_times *)
                       malloc(maxrec * sizeof(struct udf_times));

  /*
  ** MAIN LOOP:
  **
  ** Read the database sequentially.  Check the VINST on each record.
  ** If it's the one we want, extract the starting and ending times.
  */
  nr = 0;
  for (i=0; i < mNumRecs(dbf); i++) {
    char vinst[80];

    /* Determine this record's virtual instrument, and see if it's ours */
    FG(dbf, "V_INST", vinst);

    while (vinst[strlen(vinst)-1] == ' ')	/* Trim trailing spaces */
      vinst[strlen(vinst)-1] = '\0';

    if (strcmp(vinst, SNAME(scode)) == 0) {	/* Is this our vinst? */
      ByTe_4 xyear, xday, xmilli;	/* for extracting from database */

      /*
      ** If we're out of memory, reallocate twice the amount of space
      */
      if (nr == maxrec) {
	void *tmp;

	tmp = (void*)malloc(maxrec * sizeof(struct udf_times) * 2);

	memcpy(tmp, udf_times_list, maxrec*sizeof(struct udf_times));
	free(udf_times_list);
	udf_times_list = tmp;

	maxrec *= 2;
      }

      /*
      ** Extract the fields from the database, and store as needed
      */
      FG(dbf, "B_YR",   &xyear);
      FG(dbf, "B_DAY",  &xday);
      FG(dbf, "B_MSEC", &xmilli);
      udfdlm_time_fill(&udf_times_list[nr].btime, xyear, xday, xmilli);

      FG(dbf, "E_YR",   &xyear);
      FG(dbf, "E_DAY",  &xday);
      FG(dbf, "E_MSEC", &xmilli);
      udfdlm_time_fill(&udf_times_list[nr].etime, xyear, xday, xmilli);

      ++nr;
    }

    /* NEXT! */
    if (i != mNumRecs(dbf)-1)
      if (Skip(dbf, ndx, 1) != SUCCESS)
	idl_barf("UDF_TIMES: Database parse error %s", dbf_msg());
  }

  /* Clean up */
  if (CloseDbf(dbf) != SUCCESS)
    IDL_Message(IDL_M_NAMED_GENERIC, IDL_MSG_RET, "CloseDbf failed");

  if (nr == 0)
    idl_barf("UDF_TIMES: No data found for '%s'", SNAME(scode));

  /* Store the results into an array of IDL structures */
  return IDL_ImportArray(1, &nr, IDL_TYP_STRUCT, (UCHAR*)udf_times_list, 
                         UdfFree, s_udf_times);
}
