#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "libbase_udf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/**************\
|*  UDF_DONE  *|  Cleans up all memory and closes all of the UDFs
\**************/

PROCEDURE UDF_DONE( int Argc, IDL_VPTR Argv[], char *kw_unused )
{
   extern struct fh_cache fh_list[];
  
   ByTe_4 I, EnD;
   struct fh_cache *fh;
   struct Pidf         *P;

   for ( I = 0; I < MAX_OPEN; ++I) { 
      fh = &fh_list[I];
      if (fh->is_open == 1) {
         if (fh->dA != NULL)      { free (fh->dA);           }
         if (fh->vA != NULL)      { free (fh->vA);           }
         if (fh->Begs != NULL)    { free ((void *)fh->Begs); }
         if (fh->AncInfo != NULL) { free (fh->AncInfo);      }
         if (fh->Order != NULL)   { free(fh->Order);         }   
         if (fh->pInfo != NULL)   { free(fh->pInfo);         }  
	 if (fh->mV != NULL) {
            EnD = 2 * (fh->nT + fh->nC) + 1;
	    for (I = 0; I < EnD; ++I) {
	       if (fh->mV[I] != NULL) { free(fh->mV[I]); }
	    }
	    free(fh->mV[I]);
         }

         P = (struct Pidf *)fh->PIDF;
         if (P->Fp != 0)            { fclose (P->Fp);       } 
         if (P->Groups != NULL)     { free (P->Groups);     }
         if (P->Units != NULL)      { free (P->Units);      }
         if (P->Sensors != NULL)    { free (P->Sensors);    }
         if (P->Scans != NULL)      { free (P->Scans);      }
         if (P->Ancil != NULL)      { free (P->Ancil);      }
         if (P->Modes != NULL)      { free (P->Modes);      }
         if (P->Bins != NULL)       { free (P->Bins);       }
         if (P->CMisc != NULL)      { free (P->CMisc);      }
         if (P->SMisc != NULL)      { free (P->SMisc);      }
         if (P->Pi.LatLong != NULL) { free (P->Pi.LatLong); }
         if (fh->PIDF != NULL)      { free (fh->PIDF);      }

         fh->Order   = NULL;
         fh->Units   = NULL;
         fh->Dim     = NULL;
         fh->Loc     = NULL;
         fh->Set     = NULL;
         fh->uNDef   = NULL;
         fh->Begs    = NULL;
         fh->dA      = NULL;
         fh->vA      = NULL;
         fh->AncInfo = NULL;
         fh->pInfo   = NULL;
         fh->sdef    = NULL;
         fh->PIDF    = NULL;
         fh->is_open = 0;
         fh->tV      = 0;
         fh->Key     = 0;
	 fh->dSize   = 0;
	 fh->vSize   = 0;
         fh->flags.baseunit = 1;
      }
   }

   free_experiment_info();
}
