#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "udfdlm_ansi.h"
#include "udfdlm_defs.h"

/*
** If one of the UDF functions barfs, try to extract a useful error message
*/

void udf_barf(char *where, ByTe_2 code)
{
   char buf[1024];
   int  offset = 0;

   /* If called with a location (or identifier), prepend that to the msg */

   if (where != NULL) {
      sprintf(buf, "(%s): ", where);
      offset = strlen(buf);
   }

  /* 
  ** Obtain the UDF error string for the given code.  
  **
  ** Unfortunately, not all messages are cataloged.  Thus, if we see
  ** "NOT RECOGNIZED" as part of the returned string, let's call our
  ** own (automatically-generated, but you knew that) function.
  */

   idfs_error_message_str(code, buf+offset);
   if (strstr(buf+offset, "NOT RECOGNIZED") != NULL)
     sprintf(buf+offset, "UDF error [%s]", retcode_to_ascii(code));

   IDL_Message(IDL_M_NAMED_GENERIC, IDL_MSG_LONGJMP, buf);
}
