#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "idf_defs.h"
#include "user_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "Util1Ansi.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

/***************\
|*  UDF_TIMES  *|  Given a key, return an array of times available in the UDF
\***************/

PROCEDURE UDF_VFREE(int Argc, IDL_VPTR Argv[], char *kw_unused)
{
   extern struct fh_cache fh_list[];

   struct fh_cache *fh;

   ByTe_4   FhNum, I;
   ByTe_2   TyPe, EnD;
   ByTe_2   vFmT = 0;
   ByTe_1   *SecTioN;
   ByTe_2   Block = 0;

  /* Input the offset to the file handler to be queried */

   if (Argc >= 2) {
      FhNum = Argv[0]->value.i;
      fh = &fh_list[FhNum];
      if (Argv[1]->type != IDL_TYP_STRING) {
         idl_barf("UDF_VIDF: SECTION - Must Be a String Argument");
      } else { SecTioN = IDL_STRING_STR(&Argv[1]->value.str); }
   } else
      IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, "Usage: uM = UDF_VIDF(fh)");

   if (Argc > 2) {
     TyPe =  Argv[2]->type;
     Block = (TyPe == IDL_TYP_INT) ? Argv[2]->value.i : Argv[2]->value.l;
   }

/* IF no vidf structures have been defined then just leave              */

   if (fh->mV == NULL) { return; }

/* GET what we are freeing                                              */

   if ( strcmp(SecTioN, "ALL") == 0 )            { vFmT = -2; }
   if ( strcmp(SecTioN, "ALLSTRINGS") == 0 )     { vFmT = -1; }
   if ( strcmp(SecTioN, "BODY") == 0 )           { vFmT = 0;  }
   if ( strcmp(SecTioN, "TABLERAW") == 0 )       { vFmT = 1;  }
   if ( strcmp(SecTioN, "TABLECOOKED") == 0 )    { vFmT = 2;  }
   if ( strcmp(SecTioN, "CONSTANTRAW") == 0 )    { vFmT = 3;  }
   if ( strcmp(SecTioN, "CONSTANTCOOKED") == 0 ) { vFmT = 4;  }

   switch (vFmT) {
      case -2:
         EnD = 2 * (fh->nT + fh->nC) + 1;
	 for (I = 0; I < EnD; ++I) {
	    if (fh->mV[I] != NULL) { free(fh->mV[I]); }
	    fh->mV[I] = NULL;
	 }
	 fh->mV = NULL;
	 if (fh->vA != NULL) { free(fh->vA); }
	 fh->vA = NULL;
      break;
      case -1:
         EnD = 2 * (fh->nT + fh->nC) + 1;
	 for (I = 0; I < EnD; ++I) {
	    if (fh->mV[I] != NULL) { free(fh->mV[I]); }
	    fh->mV[I] = NULL;
	 }
	 fh->mV = NULL;
      break;
      case 0:
         I = 0;
	 if (fh->mV[I] != NULL) { free(fh->mV[I]); }
	 fh->mV[I] = NULL;
      break;
      case 1:
         I = Block * 2 + 1;
	 if (fh->mV[I] != NULL) { free(fh->mV[I]); }
	 fh->mV[I] = NULL;
      break;
      case 2:
         I = Block * 2 + 2;
	 if (fh->mV[I] != NULL) { free(fh->mV[I]); }
	 fh->mV[I] = NULL;
      break;
      case 3:
         I = fh->nT * 2 + Block * 2 + 1;
	 if (fh->mV[I] != NULL) { free(fh->mV[I]); }
	 fh->mV[I] = NULL;
      break;
      case 4:
         I = fh->nT * 2 + Block * 2 + 2;
	 if (fh->mV[I] != NULL) { free(fh->mV[I]); }
	 fh->mV[I] = NULL;
      break;
   }
}
