#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"
#include "udfdlm_str.h"

/**************\
|*  UDF_READ  *|  Reads one complete record from the UDF dataset
\**************/

FUNCTION UDF_READ(int Argc, IDL_VPTR Argv[], char *kw_unused)
{
   extern struct general_info ginfo;
   extern struct fh_cache fh_list[];
   extern u_ByTe_2 Version;
   extern ByTe_1 Ext[];
   extern void *UDF;

   struct idf_data    *U;
   struct Pidf        *P;
   struct PidfSensor  *Px;
   struct PidfUnit    *Pu;

   struct experiment_info *ex;
   struct ptr_rec *ptr;

   ByTe_4 NSmp, NTheta, SPer;
   float  *TmpF;
   IDL_LONG  *TmpL;
   ByTe_2 *s1;
   ByTe_2 SeN, M, N;
   ByTe_2 EndN, EndM;
   ByTe_1 TimeFilled = 0;
   ByTe_1 Fwd, Prec;

   IDL_MEMINT         one = 1;

   struct basic_struct *arr;
   ByTe_1 *base, *trac;

   struct fh_cache *fh;


   ByTe_4 FhNum;

   if (Argc == 1) {
      FhNum = Argv[0]->value.i;
      fh = &fh_list[FhNum];
   } else
      IDL_Message(IDL_M_GENERIC, IDL_MSG_LONGJMP, 
                                "Usage: dS = UDF_READ(fh)");

   /********************************************************/
   /* Allocate space for the structure if no space present */
   /********************************************************/

   U = (struct idf_data *)UDF;
   if (fh->dA == NULL) {
      if ((fh->dA = malloc(fh->dSize)) == NULL)
        idl_barf("UDF_READ: malloc(fh->dA) failed!");
   }
   arr = (struct basic_struct *)fh->dA;
   base = (ByTe_1 *) &(arr->data);

   P = (struct Pidf *)fh->PIDF;
   Px = (struct PidfSensor *)P->Sensors;
   Pu = (struct PidfUnit *)P->Units;
   
  /**************************************************************************/
  /*                                                                        */
  /*                   HERE STARTS THE GREAT DATA GRAB                      */
  /*                                                                        */
  /*  Look over the ordered sensors picking them up in the order determined */
  /*  Only pick up the VIDF sensors and not the ancillary data.             */
  /*                                                                        */
  /*  Outer loop is the matrix column loop.  Needs to be outer in case      */
  /*  there are multiple sensors and the matrix extends beyond a single     */
  /*  data record.                                                          */
  /*                                                                        */
  /**************************************************************************/

  EndN = fh->TotVSen - 1;
  EndM = fh->NCols - 1;
  for (M = 0; M < fh->NCols; M++) {
     s1 = (ByTe_2 *)fh->Order;
     for (N = 0; N < fh->TotVSen; N++, ++s1) {
        SeN = Px[*s1].VidfNum; 
        Fwd = (M == EndM && N == EndN) ? 1 : 0; 

        fh->LastRead = read_drec(fh->Key, Ext, Version, UDF, SeN, M, Fwd, 0);
        if (fh->LastRead <= 0) { udf_barf("ReadDrec", fh->LastRead); }

        if (N == 0 && M == 0) { ConvMode (fh, base); }

        NSmp = U->num_sample;
        SPer = U->spin_rate;
        if (!U->filled_data) {
           trac = base + fh->Begs[_QUAL_] + SetTrac(fh, N, M, 0, 0);
           TmpF = (float *)trac;
           *TmpF = -1.0;
	   Prec = (fh->sType == IDL_TYP_DOUBLE) ? sizeof(ReaL_8) : sizeof(ReaL_4);

           ex  = ginfo.expt;
           ptr = ex->info_ptr;
	   NSmp = (fh->sample_id == 2) ? 1 : *ptr->N_SAMPLE;

	   trac = base + fh->Begs[_SENSOR_] + SetTrac (fh, N, M, 0, 4);
	   NullCopy(trac, NSmp, Prec);
	   NTheta = (fh->flags.theta == 0) ? 1 : U->num_sample;
	   trac = base + fh->Begs[_BTHETA_] + SetTrac (fh, N, M, 0, 2);
	   NullCopy (trac, NTheta, Prec);
	   trac = base + fh->Begs[_ETHETA_] + SetTrac (fh, N, M, 0, 2);
	   NullCopy (trac, NTheta, Prec);
           continue;
        }

        if (!TimeFilled) {
	   TimeFill( fh, _BTIME_);
           TimeFilled = 1;
           trac = base + fh->Begs[_DLEN_];
           TmpL = (IDL_LONG *)trac;
           *TmpL = NSmp;
           trac = base + fh->Begs[_SPINPER_];
           TmpL = (IDL_LONG *)trac;
           *TmpL = SPer;
        }
	TimeFill( fh, _ETIME_);

        trac = base + fh->Begs[_QUAL_] + SetTrac(fh, N, M, 0, 0);
        TmpF = (float *)trac;
        *TmpF = (float)U->d_qual;

        ConvPhase (fh, base, N, M);
        ConvTheta (fh, base, N, M);
        ConvIndex (fh, base, N, M);
        ConvSensor (fh, base, N, M);
        ConvAnc (fh, base, N, M);
     }
  }

  /*
  ** Move the data we just read in into an IDL structure
  */


  return IDL_ImportArray(1, &one, IDL_TYP_STRUCT, (UCHAR*)arr, NULL, fh->sdef);
}
