#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void TagName( ByTe_1 *src, ByTe_1 *dest )
{
  int    i,j;

  strncpy(dest, src, MAX_TAG_LEN);
  dest[MAX_TAG_LEN-1] = '\0';

  /* If we see something like 'Sensor 0 (see comments)', ditch the parens */

  for (i=0; dest[i] != '\0'; i++) {
    if (dest[i] == '(') {
      dest[i] = '\0';
      break;
    }
  }

  /* Clear up trailing spaces */

  for (i=strlen(dest)-1; i>0; i--) {
    if (isspace(dest[i]))
      dest[i] = '\0';
    else
      break;
  }

  /* Look for the first non-space character */

  for (i = 0; i < 79; i++)
    if (isalnum(dest[i]))
      break;

  /* Sigh.  Some of the FUV PIDF names have a digit as the first char. */

  j = 0;
  if (isdigit(dest[i])) {
    /* If so, shift everything right by one char, and set first char to '_' */
    memmove(dest+1,dest,MAX_TAG_LEN-1);
    dest[j++] = '_';
    dest[MAX_TAG_LEN-1] = '\0';
    i++;
  }

  /* Now copy each character, converting lc to UC and space to underscore */

  for (/* j initialized above */; dest[i] != '\0'; i++,j++) {
    char *c = &dest[j];

    *c = dest[i];
    if (islower(*c))
      *c = toupper(*c);

    /*
    ** Most non-alphanumerics we convert to underscore... except '+'/'-'.
    ** Rather than try to explain the convoluted logic, I'll show some
    ** possible examples of PIDF sensor names, and what we want the
    ** resulting IDL struct name to look like:
    **
    **  Min +5V Monitor        MIN_P5V_MONITOR        ('+' to 'P')
    **  Min -5V Monitor        MIN_M5V_MONITOR        ('-' to 'M')
    **  140-190 nm WIC Image   _140_190_NM_WIC_IMAGE  ('-' to '_')
    **
    ** ...and now here are the rules:
    **
    **    1) a '+', followed by a digit, becomes 'P' (for 'Plus')
    **
    **    2) a '-', followed by a digit, becomes 'M' (for 'Minus') *UNLESS* it
    **       is also preceded by a digit, in which case it's treated as a
    **       range (and thus becomes an underscore, like everything else).
    */
    if (!isalnum(*c)) {
      char replacement = '_';

      if (isdigit(*(c+1))) {		/* e.g., '+5', '-12', but not '-X' */
	if (*c == '+') {
	  replacement = 'P';
	} else if (*c == '-') {
	  if (!(j > 0  &&  isdigit(*(c-1)))) {	/* ' -5', but not '100-200' */
	    replacement = 'M';
	  }
	}
      }

      *c = replacement;
    }
  }
  dest[j] = '\0';	/* (needed only when we trimmed leading blanks) */

  /* Finally, get rid of any trailing underscores */
  for (j=strlen(dest)-1; dest[j] == '_'; j--)
    dest[j] = '\0';
}
