#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

int ProcKeyWords (int Argc, IDL_VPTR Argv[], char *Argk) 
{
   extern struct fh_cache fh_list[];

   struct fh_cache *fh;
   struct Pidf     *P;

   ByTe_4   *l1;
   ByTe_1   *c1;
   ByTe_2   *s1;
   ByTe_2   *s2;

   u_ByTe_4 Key;
   ByTe_4   I, B;
   ByTe_4   EnD, Terminator;

                      /**********************/
                      /* Keyword parameters */
                      /**********************/

   static int         kw_sf,   kw_df,   kw_bu;    
   static int         kw_us,   kw_um,   kw_ua,   kw_ui;  
   static int         kw_az,   kw_th,   kw_in;    
   static IDL_VPTR    dformat, sformat, baseunit;
   static IDL_VPTR    sunits, munits, aunits, iunits;
   static IDL_VPTR    azimuth, theta, indices;
   static IDL_VPTR    PlainArgs[15];
   static IDL_KW_PAR  kw_list[] = {
    { "AUNITS",   IDL_TYP_LONG, 0x01, IDL_KW_VIN, &kw_ua, IDL_CHARA(aunits) },
    { "AZIMUTH",  IDL_TYP_LONG, 0x01, IDL_KW_VIN, &kw_az, IDL_CHARA(azimuth) },
    { "BASEUNIT", IDL_TYP_LONG, 0x01, IDL_KW_VIN, &kw_bu, IDL_CHARA(baseunit) },
    { "DFORMAT",  IDL_TYP_LONG, 0x01, IDL_KW_VIN, &kw_df, IDL_CHARA(dformat) },
    { "INDICES",  IDL_TYP_LONG, 0x01, IDL_KW_VIN, &kw_in, IDL_CHARA(indices) },
    { "IUNITS",   IDL_TYP_LONG, 0x01, IDL_KW_VIN, &kw_ui, IDL_CHARA(iunits) },
    { "MUNITS",   IDL_TYP_LONG, 0x01, IDL_KW_VIN, &kw_um, IDL_CHARA(munits) },
    { "SFORMAT",  IDL_TYP_LONG, 0x01, IDL_KW_VIN, &kw_sf, IDL_CHARA(sformat) },
    { "SUNITS",   IDL_TYP_LONG, 0x01, IDL_KW_VIN, &kw_us, IDL_CHARA(sunits) },
    { "THETA",    IDL_TYP_LONG, 0x01, IDL_KW_VIN, &kw_th, IDL_CHARA(theta) },
    { NULL }
   };

   /*********************************************************/
   /* Process any keyword arguments                         */
   /* Remeber IDL_KWGetParams() doesn't convert to long.    */
   /*********************************************************/

   IDL_KWCleanup(IDL_KW_MARK);
   Argc = IDL_KWGetParams(Argc, Argv, Argk, kw_list, PlainArgs, 0x01);

   /***********************/
   /* Get the filehandler */
   /***********************/

   Key = Argv[0]->value.ul;
   CheckStructs (Key);
   fh = &fh_list[FindFh(Key)];
   
   /**********************/
   /* RETURN DATA FORMAT */
   /**********************/

   fh->flags.dformat = 0;
   if (kw_df) {
     IDL_VPTR dformat_l = IDL_CvtLng(1, &dformat);
     fh->flags.dformat = dformat_l->value.l;
     IDL_Deltmp(dformat_l);
   }
   
   /**********************/
   /* BASE UNITS         */
   /**********************/

   fh->flags.baseunit = 0;
   if (kw_bu) {
     IDL_VPTR baseunit_l = IDL_CvtLng(1, &baseunit);
     fh->flags.baseunit = baseunit_l->value.l;
     IDL_Deltmp(baseunit_l);
   }

   /************************/
   /* RETURN SENSOR FORMAT */
   /************************/

   fh->flags.sformat = 0;
   if (kw_sf) {
     IDL_VPTR sformat_l = IDL_CvtLng(1, &sformat);
     fh->flags.sformat = sformat_l->value.l;
     IDL_Deltmp(sformat_l);
   }

   /*************************/
   /* RETURN AZIMUTH FORMAT */
   /*************************/

   fh->flags.azimuth = 0;
   if (kw_az) {
     IDL_VPTR azimuth_l = IDL_CvtLng(1, &azimuth);
     fh->flags.azimuth = azimuth_l->value.l;
     IDL_Deltmp(azimuth_l);
   }

   /***********************/
   /* RETURN THETA FORMAT */
   /***********************/

   fh->flags.theta = 0;
   if (kw_th) {
     IDL_VPTR theta_l = IDL_CvtLng(1, &theta);
     fh->flags.theta = theta_l->value.l;
     IDL_Deltmp(theta_l);
   }

   /*************************/
   /* RETURN INDICES FORMAT */
   /*************************/

   fh->flags.indices = 0;
   if (kw_in) {
     IDL_VPTR indices_l = IDL_CvtLng(1, &indices);
     fh->flags.indices = indices_l->value.l;
     IDL_Deltmp(indices_l);
   }

   if (kw_ui || kw_ua || kw_um || kw_us || fh->tV == 0) {
      ReadPidf (Key, fh->PIDF);
      P = (struct Pidf *)fh->PIDF;

      B = P->Ps.NSensors + P->Ps.NAncils + P->Ps.NModes + 1;

      if (B > fh->tV) {
         I = B * (sizeof(ByTe_4) + 3 * sizeof(ByTe_2));
         if ((fh->pInfo = realloc(fh->pInfo, I)) == NULL)
            idl_barf("ProcUnits: malloc(fh->pInfo)");
      }
      fh->tV = B;

      B = sizeof(ByTe_4);
      l1 = (ByTe_4 *)fh->pInfo;
      s1 = (ByTe_2 *)((ByTe_1 *)fh->pInfo + fh->tV * B);
      B += sizeof(ByTe_2);
      s2 = (ByTe_2 *)((ByTe_1 *)fh->pInfo + fh->tV * B);
      B += sizeof(ByTe_2);
      c1 = (ByTe_1 *)((ByTe_1 *)fh->pInfo + fh->tV * B);

      if (kw_us) {
         IDL_VPTR sunits_l = IDL_CvtLng(1, &sunits);
         if (sunits_l->flags & IDL_V_ARR) {
            if (sunits_l->value.arr->n_dim != 1)
              idl_barf("SUNITS Keyword must be Scalar or Vector!");

            EnD = (sunits_l->value.arr->dim[0] > P->Ps.NSensors) 
                      ? P->Ps.NSensors - 1 : sunits_l->value.arr->dim[0] - 1;
            for (I = 0; I <= EnD; I++) {
               *l1++ = I;  
               *c1++ = 'S';  
               *s1++ = ((ByTe_4 *)sunits_l->value.arr->data)[I];
               *s2++ = ((ByTe_4 *)sunits_l->value.arr->data)[I];
            }

            Terminator = ((ByTe_4  *)sunits_l->value.arr->data)[EnD];
            ++EnD;
         } else
            Terminator = sunits_l->value.l;
         IDL_Deltmp(sunits_l);

         for (I = EnD; I < P->Ps.NSensors; ++I) {
            *l1++ = I;  
            *c1++ = 'S';  
            *s1++ = Terminator;
            *s2++ = Terminator;
         }
      } else {
         for (I = 0; I < P->Ps.NSensors; ++I) {
            *l1++ = I;  
            *c1++ = 'S';  
            *s1++ = (fh->flags.baseunit == 1) ? 1000 : 0;  
            *s2++ = (fh->flags.baseunit == 1) ? 1000 : 0;  
         }
      }

      if (kw_ua) {
         IDL_VPTR aunits_l = IDL_CvtLng(1, &aunits);
         if (aunits_l->flags & IDL_V_ARR) {
            if (aunits_l->value.arr->n_dim != 1)
              idl_barf("SUNITS Keyword must be Scalar or Vector!");

            EnD = (aunits_l->value.arr->dim[0] > P->Ps.NModes) 
                      ? P->Ps.NModes - 1 : aunits_l->value.arr->dim[0] - 1;
            for (I = 0; I <= EnD; I++) {
               *l1++ = I;  
               *c1++ = 'A';  
               *s1++ = ((ByTe_4 *)aunits_l->value.arr->data)[I];
               *s2++ = ((ByTe_4 *)aunits_l->value.arr->data)[I];
            }

            Terminator = ((ByTe_4  *)aunits_l->value.arr->data)[EnD];
            ++EnD;
         } else
            Terminator = aunits_l->value.l;
         IDL_Deltmp(aunits_l);

         for (I = EnD; I < P->Ps.NAncils; ++I) {
            *l1++ = I;  
            *c1++ = 'A';  
            *s1++ = Terminator;
            *s2++ = Terminator;
         }
      } else {
         for (I = 0; I < P->Ps.NAncils; ++I) {
            *l1++ = I;  
            *c1++ = 'A';  
            *s1++ = (fh->flags.baseunit == 1) ? 1000 : 0;  
            *s2++ = (fh->flags.baseunit == 1) ? 1000 : 0;  
         }
      }

      if (kw_um) {
         IDL_VPTR munits_l = IDL_CvtLng(1, &munits);
         if (munits_l->flags & IDL_V_ARR) {
            if (munits_l->value.arr->n_dim != 1)
              idl_barf("SUNITS Keyword must be Scalar or Vector!");

            EnD = (munits_l->value.arr->dim[0] > P->Ps.NModes) 
                      ? P->Ps.NModes - 1 : munits_l->value.arr->dim[0] - 1;
            for (I = 0; I <= EnD; I++) {
               *l1++ = I;  
               *c1++ = 'M';  
               *s1++ = ((ByTe_4 *)munits_l->value.arr->data)[I];
               *s2++ = ((ByTe_4 *)munits_l->value.arr->data)[I];
            }

            Terminator = ((ByTe_4  *)munits_l->value.arr->data)[EnD];
            ++EnD;
         } else
            Terminator = munits_l->value.l;
         IDL_Deltmp(munits_l);

         for (I = EnD; I < P->Ps.NModes; ++I) {
            *l1++ = I;  
            *c1++ = 'M';  
            *s1++ = Terminator;
            *s2++ = Terminator;
         }
      } else {
         for (I = 0; I < P->Ps.NModes; ++I) {
            *l1++ = I;  
            *c1++ = 'M';  
            *s1++ = (fh->flags.baseunit == 1) ? 1000 : 0;  
            *s2++ = (fh->flags.baseunit == 1) ? 1000 : 0;  
         }
      }

      if (kw_ui) {
         IDL_VPTR iunits_l = IDL_CvtLng(1, &iunits);
         *l1++ = 0;  
         *c1++ = 'I';  
         if (iunits_l->flags & IDL_V_ARR) {
            if (iunits_l->value.arr->n_dim != 1)
              idl_barf("SUNITS Keyword must be Scalar or Vector!");
            *s1++ = ((ByTe_4 *)iunits_l->value.arr->data)[I];
            *s2++ = ((ByTe_4 *)iunits_l->value.arr->data)[I];
         } else {
            *s1++ = iunits_l->value.l;
            *s2++ = iunits_l->value.l;
         }
         IDL_Deltmp(iunits_l);
      } else {
          *l1++ = 0;  
          *c1++ = 'I';  
          *s1++ = (fh->flags.baseunit == 1) ? 1000 : 0;  
          *s2++ = (fh->flags.baseunit == 1) ? 1000 : 0;  
      }
   }

   IDL_KWCleanup(IDL_KW_CLEAN);

   return (Argc);
}
