#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "local_defs.h"
#include "user_defs.h"
#include "idf_defs.h"
#include "DbDefs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"
#include "libCfg.h"
#include "StrHier.h"
#include "dbf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"
#include "udfdlm_str.h"

void *MkVidfStruc( struct fh_cache *fh, ByTe_2 FmT, ByTe_2 Blk, ByTe_2 mN, 
                                        ByTe_2 mV, ByTe_4 *mS, ByTe_4 *sS)
{
   extern void *TmpDim;
   extern u_ByTe_2 Version;
   extern ByTe_1   Ext[];
   extern void     *TmpName;
   extern void     *TmpType;
   extern void     *TaGs;

   ByTe_4          MxT, I;
   int             nTag = 0;
   void            *rV;

   u_ByTe_4        KeY;
   ByTe_4          Dim[3], tLen = 1;
   ByTe_4          B, CritSz, SSz, TSz;

   ByTe_2          nSen, nCom, PaAppS;
   u_ByTe_2        VeR;

   ByTe_1          Name[1024];
   ByTe_1          FillFlag, nStat, nAnc, nQual, pAng, tType;
   ByTe_1          nT, nC;

   VeR = Version;

   TaGs = NULL;
   TmpName = NULL;
   TmpDim = NULL;
   TmpType = NULL;

   KeY = fh->Key;

   if (fh->mV == NULL) {
      read_idf(KeY, Ext, VeR, &nT, _NumTblS, 0, 0, 0);
      read_idf(KeY, Ext, VeR, &nC, _NumConstS, 0, 0, 0);
      B = sizeof(void **) * (2 * (nT + nC) + 1); 
      if ((fh->mV = malloc(B)) == NULL) {
         idl_barf("MkVidfStruc: malloc(fh->mV)");
      }
      B = 2 * (nT + nC) + 1; 
      for ( I = 0; I < B; ++I ) { fh->mV[I] = NULL; }
      fh->nC = nC;
      fh->nT = nT;
   }

/* ALWAYS seem to need to know the number of sensors     */

   read_idf(KeY, Ext, VeR, (ByTe_1 *)&nSen, _SeN, 0, 0, 0);

/* SWITCH on the type of structure we need to build      */
/*   0 - BODY                                            */
/*   1 - TABLERAW                                        */
/*   2 - TABLECOOKED                                     */
/*   3 - CONSTANTRAW                                     */
/*   4 - CONSTANTCOOKED                                  */

   switch (FmT) {
      case 0: 

/* READ in some of the variable fields. These are used   */
/*   to determine how many tags we need to create as     */
/*   well as array sizes to use in the tags              */

         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _NumComntS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &FillFlag, _FillFlaG, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nStat, _StatuS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nAnc, _CalSetS, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &nQual, _NumQuaL, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &pAng, _PaDefineD, 0, 0, 0);

/* GET an estimate on how many tags we need and then add */
/*   some padding.                                       */

/* WE need at least one tag per field + 4 for the extra  */
/*  lines in the contact field                           */

	 MxT = _TblScaSZ + 4;

/* STRING array fields use one tag per entry             */

         MxT += nCom + nSen + nAnc + nQual + nStat;

/* AND a 20 tag pad                                      */

         MxT += 20;

/* NOW malloc all of the memeory we need for the tags   */
   
         B = MxT * MAX_TAG_LEN;
         if ((TmpName = malloc(B)) == NULL)
            idl_barf("MkVidfStruc: malloc(TmpName)");

         B = MxT * (4 * sizeof(IDL_MEMINT));
         if ((TmpDim = malloc(B)) == NULL)
             idl_barf("MkVidfStruc: malloc(TmpDim)");

         B = MxT * sizeof(ByTe_2);
         if ((TmpType = malloc(B)) == NULL)
             idl_barf("MkVidfStruc: malloc(TmpType)");

/* INITIALIZE the number of bytes of data, string data  */
/*   and the number of tags generated.                  */

         *mS = 0;
         *sS = 0;
         nTag = 0;

/* THERE are no 2D arrays so set Dim[1] and Dim[2] to  */
/*   0 now and forget it                               */

         Dim[1] = 0;
         Dim[2] = 0;

/* GET the number of bytes that are used in all the    */
/*   80 byte string fields now                         */

	 *sS += 720 + 80 * (nCom + nSen + nAnc + nQual + nStat);

/* NOW create the tags.  Update sS in chunks           */

         Dim[0] = 0;
         *mS += SetUpTag("PROJECT", IDL_TYP_STRING, Dim, nTag++, &MxT);
         *mS += SetUpTag("MISSION", IDL_TYP_STRING, Dim, nTag++, &MxT);
         *mS += SetUpTag("EXPERIMENT", IDL_TYP_STRING, Dim, nTag++, &MxT);
         *mS += SetUpTag("INSTRUMENT", IDL_TYP_STRING, Dim, nTag++, &MxT);
	 for ( I = 0; I < 5; ++I ) { 
             sprintf (Name, "CONTACT%d", I);
             *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
         }

         *mS += SetUpTag("NUMCOMLINES", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 for ( I = 0; I < nCom; ++I ) { 
             sprintf (Name, "COMMENT%d", I);
             *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
         }

         Dim[0] = 0;
         *mS += SetUpTag("BYEAR", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("BDAY",  IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("BMSEC", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("BUSEC", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("EYEAR", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("EDAY",  IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("EMSEC", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("EUSEC", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("SMPID", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("SENMODE", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("NUMQUAL", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("ANCSETS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("NUMTBLS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("NUMCONSTS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("STATUS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("PADEFINED", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("NUMSEN", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("ARRAYLEN", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("MAXNSS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("DATALEN", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("FILLFLAG", IDL_TYP_LONG, Dim, nTag++, &MxT);
         if (FillFlag == 1 ) {
            *mS += SetUpTag("FILLVAL", IDL_TYP_ULONG, Dim, nTag++, &MxT);
         }
         *mS += SetUpTag("DAMETHOD", IDL_TYP_LONG, Dim, nTag++, &MxT);

	 if ( nStat > 0 ) {
            Dim[0] = 0;
	    for ( I = 0; I < nStat; ++I ) { 
                sprintf (Name, "STATUSNAME%d", I);
                *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
            }

            Dim[0] = nStat;
            *mS += SetUpTag("STATES", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 }

	 if ( nSen > 0 ) {
            Dim[0] = 0;
	    for ( I = 0; I < nSen; ++I ) { 
                sprintf (Name, "SENNAME%d", I);
                *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
            }
            Dim[0] = nSen;
            *mS += SetUpTag("SENTYPE", IDL_TYP_LONG, Dim, nTag++, &MxT);
            *mS += SetUpTag("SENLEN", IDL_TYP_LONG, Dim, nTag++, &MxT);
            *mS += SetUpTag("SENTIMEOFF", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 }

	 if ( nAnc > 0 ) {
            Dim[0] = 0;
	    for ( I = 0; I < nAnc; ++I ) { 
                sprintf (Name, "ANCNAME%d", I);
                *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
            }

            Dim[0] = nAnc;
            *mS += SetUpTag("ANCUSE", IDL_TYP_LONG, Dim, nTag++, &MxT);
            *mS += SetUpTag("ANCLEN", IDL_TYP_LONG, Dim, nTag++, &MxT);
            *mS += SetUpTag("ANCTARGET", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 }

	 if ( nQual > 0 ) {
            Dim[0] = 0;
	    for ( I = 0; I < nQual; ++I ) { 
                sprintf (Name, "QUALNAME%d", I);
                *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
            }
	 }

	 if ( pAng == 1 ) {
            Dim[0] = 0;
            *mS += SetUpTag("PAFORMAT", IDL_TYP_LONG, Dim, nTag++, &MxT);
            *mS += SetUpTag("PAPROJECT", IDL_TYP_STRING, Dim, nTag++, &MxT);
	    *sS += 80;
            *mS += SetUpTag("PAMISSION", IDL_TYP_STRING, Dim, nTag++, &MxT);
	    *sS += 80;
            *mS += SetUpTag("PAEXPER", IDL_TYP_STRING, Dim, nTag++, &MxT);
	    *sS += 80;
            *mS += SetUpTag("PAINST", IDL_TYP_STRING, Dim, nTag++, &MxT);
	    *sS += 80;
            *mS += SetUpTag("PAVINST", IDL_TYP_STRING, Dim, nTag++, &MxT);
	    *sS += 80;

            Dim[0] = 3;
            *mS += SetUpTag("PAMFSENS", IDL_TYP_LONG, Dim, nTag++, &MxT);

            read_idf(KeY, Ext, VeR, (ByTe_1 *)&PaAppS, _PaAppS, 0, 0, 0);
            Dim[0] = 0;
            *mS += SetUpTag("MFALGSTEPNUM", IDL_TYP_LONG, Dim, nTag++, &MxT);

	    if (PaAppS > 0 ) {
               Dim[0] = PaAppS;
               *mS += SetUpTag("PATBLS", IDL_TYP_LONG, Dim, nTag++, &MxT);
               *mS += SetUpTag("PAOPERS", IDL_TYP_LONG, Dim, nTag++, &MxT);
	    }
	 }

         sprintf (Name, "%s_BV", fh->BaseName);

      break;
      case 1: 
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _TblDescLeN, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&CritSz, _CritActSZ, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&SSz, _TblScaSZ, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&TSz, _TblEleSZ, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nSen, _SeN, 0, 0, 0);
         read_idf(KeY, Ext, VeR, &tType, _TblTypE, Blk, 0, 0);

	 MxT = _TbL - _TblScaSZ + 1;
         MxT += nCom;
	 if (tType == 1) { MxT += TSz; }
         MxT += 20;

         *sS = nCom * 80;
	 if (tType == 1) { *sS += TSz * 80; }
         
         B = MxT * MAX_TAG_LEN;
         if ((TmpName = malloc(B)) == NULL)
            idl_barf("MkDataStruc: malloc(TmpName)");

         B = MxT * (4 * sizeof(IDL_LONG));
         if ((TmpDim = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpDim)");

         B = MxT * sizeof(ByTe_2);
         if ((TmpType = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpType)");

         *mS = 0;
         *sS = 0;
         nTag = 0;

         Dim[1] = 0;
         Dim[2] = 0;

         Dim[0] = 0;
         *mS += SetUpTag("TBLSCASZ", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("TBLELEMSZ", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("TBLTYPE", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("NUMCOMLINES", IDL_TYP_LONG, Dim, nTag++, &MxT);

	 for ( I = 0; I < nCom; ++I ) { 
             sprintf (Name, "TBLCOMMENT%d", I);
             *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
         }

         *mS += SetUpTag("TBLVAR", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("TBLEXPAND",  IDL_TYP_LONG, Dim, nTag++, &MxT);

	 if ( CritSz > 0 ) {
            Dim[0] = nSen;
            *mS += SetUpTag("TBLCRITSTAT", IDL_TYP_LONG, Dim, nTag++, &MxT);
            *mS += SetUpTag("TBLCRITOFFS", IDL_TYP_LONG, Dim, nTag++, &MxT);
            Dim[0] = CritSz;
            *mS += SetUpTag("TBLCRITACT", IDL_TYP_LONG, Dim, nTag++, &MxT);
	 }

         Dim[0] = nSen;
         *mS += SetUpTag("TBLFMT", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("TBLOFFSETS", IDL_TYP_LONG, Dim, nTag++, &MxT);

         if  (SSz != 0) {
	    Dim[1] = ( SSz < 0 ) ? -SSz : SSz;
            *mS += SetUpTag("TBLSCALEVALS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         }

	 if (tType != 1) {
	    Dim[0] = TSz;
            *mS += SetUpTag("TBLVALS", IDL_TYP_LONG, Dim, nTag++, &MxT);
         } else {
            Dim[0] = 0;
	    for ( I = 0; I < TSz; ++I ) { 
                sprintf (Name, "TBLVALUE%d", I);
                *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
            }
	 }

         sprintf (Name, "%s_TR%d", fh->BaseName, Blk);

      break;
      case 2: 
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _TblDescLeN, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, &tType, _TblTypE, Blk, 0, 0);

	 MxT = _TbL - _TblScaSZ + 1;
         MxT += nCom;
	 if (tType == 1) { MxT += TSz; }
         MxT += 20;

         *sS = nCom * 80;
	 if (tType == 1) { *sS += TSz * 80; }

/* DETERMINE HOW MANY TABLE VALUES ARE COMING BACK.                     */

         tLen = NumTblVals (KeY, Blk, mN); 

         B = MxT * MAX_TAG_LEN;
         if ((TmpName = malloc(B)) == NULL)
            idl_barf("MkDataStruc: malloc(TmpName)");

         B = MxT * (4 * sizeof(IDL_LONG));
         if ((TmpDim = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpDim)");

         B = MxT * sizeof(ByTe_2);
         if ((TmpType = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpType)");

         *mS = 0;
         *sS = 0;
         nTag = 0;

         Dim[0] = 0;
         Dim[1] = 0;
         Dim[2] = 0;
         *mS += SetUpTag("TBLTYPE", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("NUMCOMLINES", IDL_TYP_LONG, Dim, nTag++, &MxT);

	 for ( I = 0; I < nCom; ++I ) { 
             sprintf (Name, "TBLCOMMENT%d", I);
             *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
         }

         *mS += SetUpTag("TBLVAR", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("TBLFMT", IDL_TYP_LONG, Dim, nTag++, &MxT);

	 if (tType != 1) {
	    Dim[0] = tLen;
            *mS += SetUpTag("TBLVALS", IDL_TYP_DOUBLE, Dim, nTag++, &MxT);
         } else {
            Dim[0] = 0;
	    for ( I = 0; I < tLen; ++I ) { 
               sprintf (Name, "TBLVALUE%d", I);
               *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
            }
	 }
         sprintf (Name, "%s_TC%d", fh->BaseName, Blk);

      break;
      case 3: 
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _ConstDescLeN, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nSen, _SeN, 0, 0, 0);

	 MxT = _ConsT - _ConstID + 1;
         MxT += nCom;
	 if (tType == 1) { MxT += TSz; }
         MxT += 10;

         *sS = nCom * 80;

         B = MxT * MAX_TAG_LEN;
         if ((TmpName = malloc(B)) == NULL)
            idl_barf("MkDataStruc: malloc(TmpName)");

         B = MxT * (4 * sizeof(IDL_LONG));
         if ((TmpDim = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpDim)");

         B = MxT * sizeof(ByTe_2);
         if ((TmpType = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpType)");

         *mS = 0;
         *sS = 0;
         nTag = 0;

         Dim[1] = 0;
         Dim[2] = 0;

         Dim[0] = 0;
         *mS += SetUpTag("CONSTANTID", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("NUMCOMLINES", IDL_TYP_LONG, Dim, nTag++, &MxT);

	 for ( I = 0; I < nCom; ++I ) { 
             sprintf (Name, "CONSTCOMMENT%d", I);
             *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
         }

         Dim[0] = nSen;
         *mS += SetUpTag("CONSTSCA", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("CONSTVAL", IDL_TYP_LONG, Dim, nTag++, &MxT);

         sprintf (Name, "%s_CR%d", fh->BaseName, Blk);
      break;
      case 4: 
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nCom, _ConstDescLeN, Blk, 0, 0);
         read_idf(KeY, Ext, VeR, (ByTe_1 *)&nSen, _SeN, 0, 0, 0);

	 MxT = _ConsT - _ConstID + 1;
         MxT += nCom;
	 if (tType == 1) { MxT += TSz; }
         MxT += 10;


         B = MxT * MAX_TAG_LEN;
         if ((TmpName = malloc(B)) == NULL)
            idl_barf("MkDataStruc: malloc(TmpName)");

         B = MxT * (4 * sizeof(IDL_LONG));
         if ((TmpDim = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpDim)");

         B = MxT * sizeof(ByTe_2);
         if ((TmpType = malloc(B)) == NULL)
             idl_barf("MkDataStruc: malloc(TmpType)");

         *mS = 0;
         *sS = 0;
         nTag = 0;

         Dim[1] = 0;
         Dim[2] = 0;

         Dim[0] = 0;
         *mS += SetUpTag("CONSTANTID", IDL_TYP_LONG, Dim, nTag++, &MxT);
         *mS += SetUpTag("NUMCOMLINES", IDL_TYP_LONG, Dim, nTag++, &MxT);

	 for ( I = 0; I < nCom; ++I ) { 
             sprintf (Name, "CONSTCOMMENT%d", I);
             *mS += SetUpTag(Name, IDL_TYP_STRING, Dim, nTag++, &MxT);
         }

         Dim[0] = nSen;
         *mS += SetUpTag("CONSTVAL", IDL_TYP_DOUBLE, Dim, nTag++, &MxT);

         sprintf (Name, "%s_CC%d", fh->BaseName, Blk);
      break;
   }

   *mS += 500;
   *sS += 240;

   FormTags (nTag);
   rV = IDL_MakeStruct(Name, TaGs);

   free (TaGs);
   free (TmpName);
   free (TmpDim);
   free (TmpType);

   return rV;
}
