package provide UDFUnits 1.0

proc uUStart { } {
   global uUANS

# READ in the preference file
                                                                                
   GUIprefsRead

   set lineage [list PROJECT \
                     MISSION \
                     EXPERIMENT \
                     INSTRUMENT \
                     VIRTUAL ]

   set dU [list MINIMUM MAXIMUM] 
   set sS [list STANDARD COLLAPSE GROUP] 
   set dF [list FLOAT DOUBLE] 
   set nT [list ONCE/READ ONCE/DATA] 

   if { [winfo exists .inTOPa] == 0 } {
      wm title . "UNITS SELECTION PACKAGE"

      GUIFrame .inTOPa -1 pack|top||both|true
      GUIFrame .inTOPb -1 pack|top||both|true
      GUIFrame .inMAIN -1 pack|top||both|true
      GUIFrame .inMAIN.left -1 pack|left|nw
      GUIFrame .inMAIN.right -1 pack|left|nw

      set W ".inTOPa"
      GUIbuttonPush $W.quit QUIT pack|right "exit"  10
      GUIbuttonPush $W.save SAVE pack|right "uUSave"  10
      GUIbuttonPush $W.read READ pack|right "uURdPidf"  10

      set W ".inTOPb"
      GUIFrame $W.units -1 pack|left
      GUIFrame $W.storage -1 pack|left
      GUIFrame $W.fmt -1 pack|left
      GUIFrame $W.azi -1 pack|left
      GUIFrame $W.elev -1 pack|left
      GUIFrame $W.arindx -1 pack|left

      GUILabel $W.units.l "UNITS" center grid|0|0|news
      set LaB [lindex $dU $uUANS(DefU)]
      GUIbuttonToggle $W.units.b $LaB grid|1|0|news $dU \
          "GUIoptsToggle $W.units.b uUANS(DefU) ALT" 1 -1

      GUILabel $W.storage.l "STORAGE" center grid|0|0|news
      set LaB [lindex $sS $uUANS(SenSet)]
      GUIbuttonMenu $W.storage.b $LaB grid|1|0|news $sS \
          "GUIoptsProcess $W.storage.b uUANS(SenSet) ALT " 1 -1

      GUILabel $W.fmt.l "FORMAT" center grid|0|0|news
      set LaB [lindex $dF $uUANS(FmT)]
      GUIbuttonToggle $W.fmt.b $LaB grid|1|0|news $dF \
          "GUIoptsToggle $W.fmt.b uUANS(FmT) ALT" 1 -1

      GUILabel $W.azi.l "AZIMUTH" center grid|0|0|news
      set LaB [lindex $nT $uUANS(Azimuth)]
      GUIbuttonToggle $W.azi.b $LaB grid|1|0|news $nT \
          "GUIoptsToggle $W.azi.b uUANS(Azimuth) ALT" 1 -1

      GUILabel $W.elev.l "ELEVATION" center grid|0|0|news
      set LaB [lindex $nT $uUANS(Elev)]
      GUIbuttonToggle $W.elev.b $LaB grid|1|0|news $nT \
          "GUIoptsToggle $W.elev.b uUANS(Elev) ALT" 1 -1

      GUILabel $W.arindx.l "ARRAY INDICES" center grid|0|0|news
      set LaB [lindex $nT $uUANS(ArIndx)]
      GUIbuttonToggle $W.arindx.b $LaB grid|1|0|news $nT \
          "GUIoptsToggle $W.arindx.b uUANS(ArIndx) ALT" 1 -1

      set oP(0) N
      set oP(1) V
      set oP(4) [list NULL NULL NULL]
      set oP(5) YES
      GUudfPMEIV .inMAIN.left uUANS oP

      if $uUANS(DefMenu) { uUFillIn }
   }
}
